/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.pattern.Part;

public class CronPatternBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    final String[] parts = new String[7];

    public static CronPatternBuilder of() {
        return new CronPatternBuilder();
    }

    public CronPatternBuilder setValues(Part part, int ... values) {
        for (int value : values) {
            part.checkValue(value);
        }
        return this.set(part, ArrayUtil.join((Object)values, (CharSequence)","));
    }

    public CronPatternBuilder setRange(Part part, int begin, int end) {
        Assert.notNull((Object)((Object)part));
        part.checkValue(begin);
        part.checkValue(end);
        return this.set(part, StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{begin, end}));
    }

    public CronPatternBuilder set(Part part, String value) {
        this.parts[part.ordinal()] = value;
        return this;
    }

    public String build() {
        for (int i = Part.MINUTE.ordinal(); i < Part.YEAR.ordinal(); ++i) {
            if (!StrUtil.isBlank((CharSequence)this.parts[i])) continue;
            this.parts[i] = "*";
        }
        return StrJoiner.of((CharSequence)" ").setNullMode(StrJoiner.NullMode.IGNORE).append((Object[])this.parts).toString();
    }
}

