/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;

public class Calculator {
    private final Stack<String> postfixStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        return new Calculator().calculate(expression);
    }

    public double calculate(String expression) {
        this.prepare(Calculator.transform(expression));
        Stack<String> resultStack = new Stack<String>();
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentOp = this.postfixStack.pop();
            if (!this.isOperator(currentOp.charAt(0))) {
                currentOp = currentOp.replace("~", "-");
                resultStack.push(currentOp);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentOp.charAt(0));
            resultStack.push(tempResult.toString());
        }
        return NumberUtil.mul(resultStack.toArray(new String[0])).doubleValue();
    }

    private void prepare(String expression) {
        Stack<Character> opStack = new Stack<Character>();
        opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = ((Character)opStack.peek()).charValue();
                if (currentOp == ')') {
                    while (((Character)opStack.peek()).charValue() != '(') {
                        this.postfixStack.push(String.valueOf(opStack.pop()));
                    }
                    opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(opStack.pop()));
                        peekOp = ((Character)opStack.peek()).charValue();
                    }
                    opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && currentIndex < arr.length && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (((Character)opStack.peek()).charValue() != ',') {
            this.postfixStack.push(String.valueOf(opStack.pop()));
        }
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')' || c == '%';
    }

    private boolean compare(char cur, char peek) {
        int offset = 40;
        if (cur == '%') {
            cur = (char)47;
        }
        if (peek == '%') {
            peek = (char)47;
        }
        return this.operatPriority[peek - 40] >= this.operatPriority[cur - 40];
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        BigDecimal result;
        BigDecimal first = NumberUtil.toBigDecimal(firstValue);
        BigDecimal second = NumberUtil.toBigDecimal(secondValue);
        if ((currentOp == '/' || currentOp == '%') && second.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero: cannot divide " + firstValue + " by zero");
        }
        switch (currentOp) {
            case '+': {
                result = NumberUtil.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = NumberUtil.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = NumberUtil.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = NumberUtil.div(firstValue, secondValue);
                break;
            }
            case '%': {
                result = NumberUtil.toBigDecimal(firstValue).remainder(NumberUtil.toBigDecimal(secondValue));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + currentOp);
            }
        }
        return result;
    }

    private static String transform(String expression) {
        expression = StrUtil.cleanBlank(expression);
        expression = StrUtil.removeSuffix(expression, "=");
        char[] arr = expression.toCharArray();
        StringBuilder out = new StringBuilder(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (CharUtil.equals(c, 'x', true)) {
                out.append('*');
                continue;
            }
            if (c == '+' || c == '-') {
                boolean unaryContext;
                int j;
                char prevOut;
                int outLen = out.length();
                if (outLen > 0 && ((prevOut = out.charAt(outLen - 1)) == 'e' || prevOut == 'E')) {
                    if (c != '-') continue;
                    out.append('~');
                    continue;
                }
                for (j = i - 1; j >= 0 && Character.isWhitespace(arr[j]); --j) {
                }
                boolean bl = unaryContext = j < 0 || Calculator.isPrevCharOperatorOrLeftParen(arr[j]);
                if (unaryContext) {
                    boolean netNegative;
                    int k;
                    int minusCount = 0;
                    for (k = i; k < arr.length && (arr[k] == '+' || arr[k] == '-'); ++k) {
                        if (arr[k] != '-') continue;
                        ++minusCount;
                    }
                    boolean bl2 = netNegative = minusCount % 2 == 1;
                    if (netNegative) {
                        out.append('~');
                    }
                    i = k - 1;
                    continue;
                }
                out.append(c);
                continue;
            }
            out.append(c);
        }
        String result = out.toString();
        char[] resArr = result.toCharArray();
        if (resArr.length >= 2 && resArr[0] == '~' && resArr[1] == '(') {
            resArr[0] = 45;
            return "0" + new String(resArr);
        }
        return result;
    }

    private static boolean isPrevCharOperatorOrLeftParen(char c) {
        return c == '%' || c == '+' || c == '-' || c == '*' || c == '/' || c == '(';
    }
}

