/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import java.util.Calendar;

public class DateModifier {
    private static final int[] IGNORE_FIELDS = new int[]{11, 9, 8, 6, 4, 3};

    public static Calendar modify(Calendar calendar, int dateField, ModifyType modifyType) {
        if (9 == dateField) {
            boolean isAM = DateUtil.isAM(calendar);
            switch (modifyType) {
                case TRUNCATE: {
                    calendar.set(11, isAM ? 0 : 12);
                    break;
                }
                case CEILING: {
                    calendar.set(11, isAM ? 11 : 23);
                    break;
                }
                case ROUND: {
                    int min = isAM ? 0 : 12;
                    int max = isAM ? 11 : 23;
                    int href = (max - min) / 2 + 1;
                    int value = calendar.get(11);
                    calendar.set(11, value < href ? min : max);
                }
            }
            return DateModifier.modify(calendar, dateField + 1, modifyType);
        }
        for (int i = dateField + 1; i <= 14; ++i) {
            if (ArrayUtil.contains(IGNORE_FIELDS, i) || (4 == dateField || 3 == dateField ? 5 == i : 7 == i)) continue;
            DateModifier.modifyField(calendar, i, modifyType);
        }
        return calendar;
    }

    private static void modifyField(Calendar calendar, int field, ModifyType modifyType) {
        if (10 == field) {
            field = 11;
        }
        switch (modifyType) {
            case TRUNCATE: {
                calendar.set(field, DateUtil.getBeginValue(calendar, field));
                break;
            }
            case CEILING: {
                calendar.set(field, DateUtil.getEndValue(calendar, field));
                break;
            }
            case ROUND: {
                int min = DateUtil.getBeginValue(calendar, field);
                int max = DateUtil.getEndValue(calendar, field);
                int href = 7 == field ? (min + 3) % 7 : (max - min) / 2 + 1;
                int value = calendar.get(field);
                calendar.set(field, value < href ? min : max);
            }
        }
    }

    public static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }
}

