package cn.hutool.captcha;

import cn.hutool.captcha.generator.CodeGenerator;

/**
 * 图形验证码工具
 *
 * @author looly
 * @since 3.1.2
 */
public class CaptchaUtil {

	/**
	 * 创建线干扰的验证码，默认5位验证码，150条干扰线
	 *
	 * @param width  图片宽
	 * @param height 图片高
	 * @return {@link LineCaptcha}
	 */
	public static LineCaptcha createLineCaptcha(int width, int height) {
		return new LineCaptcha(width, height);
	}

	/**
	 * 创建线干扰的验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param codeCount 字符个数
	 * @param lineCount 干扰线条数
	 * @return {@link LineCaptcha}
	 */
	public static LineCaptcha createLineCaptcha(int width, int height, int codeCount, int lineCount) {
		return new LineCaptcha(width, height, codeCount, lineCount);
	}

	/**
	 * 创建线干扰的验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param generator 验证码生成器
	 * @param lineCount 干扰线条数
	 * @return {@link LineCaptcha}
	 */
	public static LineCaptcha createLineCaptcha(int width, int height, CodeGenerator generator, int lineCount) {
		return new LineCaptcha(width, height, generator, lineCount);
	}

	/**
	 * 创建线干扰的验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param codeCount 字符个数
	 * @param lineCount 干扰线条数
	 * @param size      字体的大小 高度的倍数
	 * @return {@link LineCaptcha}
	 */
	public static LineCaptcha createLineCaptcha(int width, int height, int codeCount, int lineCount, float size) {
		return new LineCaptcha(width, height, codeCount, lineCount, size);
	}
	// ------------------------- lineCaptcha end -------------------------

	/**
	 * 创建圆圈干扰的验证码，默认5位验证码，15个干扰圈
	 *
	 * @param width  图片宽
	 * @param height 图片高
	 * @return {@link CircleCaptcha}
	 * @since 3.2.3
	 */
	public static CircleCaptcha createCircleCaptcha(int width, int height) {
		return new CircleCaptcha(width, height);
	}

	/**
	 * 创建圆圈干扰的验证码
	 *
	 * @param width       图片宽
	 * @param height      图片高
	 * @param codeCount   字符个数
	 * @param circleCount 干扰圆圈条数
	 * @return {@link CircleCaptcha}
	 * @since 3.2.3
	 */
	public static CircleCaptcha createCircleCaptcha(int width, int height, int codeCount, int circleCount) {
		return new CircleCaptcha(width, height, codeCount, circleCount);
	}

	/**
	 * 创建圆圈干扰的验证码
	 *
	 * @param width       图片宽
	 * @param height      图片高
	 * @param generator   验证码生成器
	 * @param circleCount 干扰圆圈条数
	 * @return {@link CircleCaptcha}
	 */
	public static CircleCaptcha createCircleCaptcha(int width, int height, CodeGenerator generator, int circleCount) {
		return new CircleCaptcha(width, height, generator, circleCount);
	}

	/**
	 * 创建圆圈干扰的验证码
	 *
	 * @param width       图片宽
	 * @param height      图片高
	 * @param codeCount   字符个数
	 * @param circleCount 干扰圆圈条数
	 * @param size        字体的大小 高度的倍数
	 * @return {@link CircleCaptcha}
	 */
	public static CircleCaptcha createCircleCaptcha(int width, int height, int codeCount, int circleCount, float size) {
		return new CircleCaptcha(width, height, codeCount, circleCount, size);
	}
	// ------------------------- circleCaptcha end -------------------------

	/**
	 * 创建扭曲干扰的验证码，默认5位验证码
	 *
	 * @param width  图片宽
	 * @param height 图片高
	 * @return {@link ShearCaptcha}
	 * @since 3.2.3
	 */
	public static ShearCaptcha createShearCaptcha(int width, int height) {
		return new ShearCaptcha(width, height);
	}

	/**
	 * 创建扭曲干扰的验证码，默认5位验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param codeCount 字符个数
	 * @param thickness 干扰线宽度
	 * @return {@link ShearCaptcha}
	 * @since 3.3.0
	 */
	public static ShearCaptcha createShearCaptcha(int width, int height, int codeCount, int thickness) {
		return new ShearCaptcha(width, height, codeCount, thickness);
	}

	/**
	 * 创建扭曲干扰的验证码，默认5位验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param generator 验证码生成器
	 * @param thickness 干扰线宽度
	 * @return {@link ShearCaptcha}
	 */
	public static ShearCaptcha createShearCaptcha(int width, int height, CodeGenerator generator, int thickness) {
		return new ShearCaptcha(width, height, generator, thickness);
	}

	/**
	 * 创建扭曲干扰的验证码，默认5位验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param codeCount 字符个数
	 * @param thickness 干扰线宽度
	 * @param size      字体的大小 高度的倍数
	 * @return {@link ShearCaptcha}
	 */
	public static ShearCaptcha createShearCaptcha(int width, int height, int codeCount, int thickness, float size) {
		return new ShearCaptcha(width, height, codeCount, thickness, size);
	}
	// ------------------------- shearCaptcha end -------------------------

	/**
	 * 创建GIF验证码
	 *
	 * @param width  宽
	 * @param height 高
	 * @return {@link GifCaptcha}
	 */
	public static GifCaptcha createGifCaptcha(int width, int height) {
		return new GifCaptcha(width, height);
	}

	/**
	 * 创建GIF验证码
	 *
	 * @param width     宽
	 * @param height    高
	 * @param codeCount 字符个数
	 * @return {@link GifCaptcha}
	 */
	public static GifCaptcha createGifCaptcha(int width, int height, int codeCount) {
		return new GifCaptcha(width, height, codeCount);
	}

	/**
	 * 创建GIF验证码
	 *
	 * @param width     宽
	 * @param height    高
	 * @param generator 验证码生成器
	 * @param thickness 验证码干扰元素个数
	 * @return {@link GifCaptcha}
	 */
	public static GifCaptcha createGifCaptcha(int width, int height, CodeGenerator generator, int thickness) {
		return new GifCaptcha(width, height, generator, thickness);
	}

	/**
	 * 创建圆圈干扰的验证码
	 *
	 * @param width     图片宽
	 * @param height    图片高
	 * @param codeCount 字符个数
	 * @param thickness 验证码干扰元素个数
	 * @param size      字体的大小 高度的倍数
	 * @return {@link GifCaptcha}
	 */
	public static GifCaptcha createGifCaptcha(int width, int height, int codeCount, int thickness, float size) {
		return new GifCaptcha(width, height, codeCount, thickness, size);
	}
	// ------------------------- gifCaptcha end -------------------------

}
