/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Session;
import java.util.Map;

public enum JschSessionPool {
    INSTANCE;

    private final SimpleCache<String, Session> cache = new SimpleCache();

    public Session get(String key) {
        return this.cache.get(key);
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key, Session::isConnected, () -> JschUtil.openSession(sshHost, sshPort, sshUser, sshPass));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String prvkey, byte[] passphrase) {
        String key = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key, Session::isConnected, () -> JschUtil.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, byte[] prvkey, byte[] passphrase) {
        String key = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key, Session::isConnected, () -> JschUtil.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public void put(String key, Session session) {
        this.cache.put(key, session);
    }

    public void close(String key) {
        Session session = this.get(key);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.cache.remove(key);
    }

    public void remove(Session session) {
        if (null != session) {
            String key = null;
            for (Map.Entry<String, Session> entry : this.cache) {
                if (!session.equals(entry.getValue())) continue;
                key = entry.getKey();
                break;
            }
            if (null != key) {
                this.cache.remove(key);
            }
        }
    }

    public void closeAll() {
        for (Map.Entry<String, Session> entry : this.cache) {
            Session session = entry.getValue();
            if (session == null || !session.isConnected()) continue;
            session.disconnect();
        }
        this.cache.clear();
    }
}

