/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter.filter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.bloomfilter.bitMap.BitMap;
import cn.hutool.bloomfilter.bitMap.IntMap;
import cn.hutool.bloomfilter.bitMap.LongMap;
import cn.hutool.core.lang.Assert;

public abstract class AbstractFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    protected static int DEFAULT_MACHINE_NUM = 32;
    private BitMap bm = null;
    protected long size;

    public AbstractFilter(long maxValue, int machineNum) {
        this.init(maxValue, machineNum);
    }

    public AbstractFilter(long maxValue) {
        this(maxValue, DEFAULT_MACHINE_NUM);
    }

    public void init(long maxValue, int machineNum) {
        this.size = Assert.checkBetween(maxValue, 1L, Integer.MAX_VALUE);
        int capacity = (int)((this.size + (long)machineNum - 1L) / (long)machineNum);
        switch (machineNum) {
            case 32: {
                this.bm = new IntMap(capacity);
                break;
            }
            case 64: {
                this.bm = new LongMap(capacity);
                break;
            }
            default: {
                throw new RuntimeException("Error Machine number!");
            }
        }
    }

    @Override
    public boolean contains(String str) {
        return this.bm.contains(Math.abs(this.hash(str)));
    }

    @Override
    public boolean add(String str) {
        long hash = Math.abs(this.hash(str));
        if (this.bm.contains(hash)) {
            return false;
        }
        this.bm.add(hash);
        return true;
    }

    public abstract long hash(String var1);
}

