/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.model.gemini;

import cn.hutool.ai.AIException;
import cn.hutool.ai.core.AIConfig;
import cn.hutool.ai.core.BaseAIService;
import cn.hutool.ai.core.Message;
import cn.hutool.ai.model.gemini.GeminiCommon;
import cn.hutool.ai.model.gemini.GeminiService;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GeminiServiceImpl
extends BaseAIService
implements GeminiService {
    private final String GENERATE_CONTENT = ":generateContent";
    private final String STREAM_GENERATE_CONTENT = ":streamGenerateContent";
    private final String PREDICT = ":predict";
    private final String PREDICT_LONG_RUNNING = ":predictLongRunning";
    private final String UPLOAD_BASE_URL = "https://generativelanguage.googleapis.com/upload/v1beta/files";

    public GeminiServiceImpl(AIConfig config) {
        super(config);
    }

    private String getEndpoint(boolean stream) {
        String action = stream ? ":streamGenerateContent" : ":generateContent";
        return "/models/" + this.config.getModel() + action;
    }

    private String getPredictImageEndpoint() {
        return "/models/" + this.config.getModel() + ":predict";
    }

    private String getPredictVideoEndpoint() {
        return "/models/" + this.config.getModel() + ":predictLongRunning";
    }

    @Override
    public String chat(List<Message> messages) {
        Map<String, Object> paramMap = this.buildChatRequestMap(messages);
        HttpResponse response = this.sendPost(this.getEndpoint(false), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatRequestMap(messages);
        String endpoint = this.getEndpoint(true) + "?alt=sse";
        ThreadUtil.newThread(() -> this.sendPostStream(endpoint, paramMap, callback), "gemini-chat-sse").start();
    }

    @Override
    public String chatMultimodal(String prompt, List<String> mediaList) {
        Map<String, Object> paramMap = this.buildMultimodalRequestMap(prompt, mediaList);
        HttpResponse response = this.sendPost(this.getEndpoint(false), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public void chatMultimodal(String prompt, List<String> mediaList, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildMultimodalRequestMap(prompt, mediaList);
        String endpoint = this.getEndpoint(true) + "?alt=sse";
        ThreadUtil.newThread(() -> this.sendPostStream(endpoint, paramMap, callback), "gemini-m-sse").start();
    }

    @Override
    public String chatJson(List<Message> messages) {
        Map<String, Object> paramMap = this.buildChatRequestMap(messages);
        HashMap<String, String> genConfig = MapUtil.get(paramMap, (Object)"generationConfig", Map.class);
        if (genConfig == null) {
            genConfig = new HashMap<String, String>();
        }
        genConfig.put("response_mime_type", "application/json");
        HttpResponse response = this.sendPost(this.getEndpoint(false), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public String predictImage(String prompt) {
        Map<String, Object> paramMap = this.buildPredictImageRequestMap(prompt);
        HttpResponse response = this.sendPost(this.getPredictImageEndpoint(), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public String predictVideo(String prompt) {
        Map<String, Object> paramMap = this.buildPredictVideoRequestMap(prompt);
        HttpResponse response = this.sendPost(this.getPredictVideoEndpoint(), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public String getVideoOperation(String operationName) {
        String endPoint = "/" + operationName;
        HttpResponse response = this.sendGet(endPoint);
        return response.body();
    }

    @Override
    public void downLoadVideo(String videoUri, String filePath) {
        if (StrUtil.isBlank(videoUri)) {
            throw new AIException("Video URI is empty");
        }
        HttpResponse response = ((HttpRequest)HttpRequest.get(videoUri).header("x-goog-api-key", this.config.getApiKey())).setFollowRedirects(true).executeAsync();
        if (!response.isOk()) {
            throw new AIException("Download failed with status: " + response.getStatus());
        }
        response.writeBody(FileUtil.file(filePath));
    }

    @Override
    public String textToSpeech(String prompt) {
        Map<String, Object> paramMap = this.buildTextToSpeechRequestMap(prompt);
        HttpResponse response = this.sendPost(this.getEndpoint(false), JSONUtil.toJsonStr(paramMap));
        return response.body();
    }

    @Override
    public String textToSpeech(String prompt, String voice) {
        HashMap<String, HashMap<String, String>> voiceConfig = MapUtil.of("prebuilt_voice_config", MapUtil.of("voice_name", voice));
        this.config.putAdditionalConfigByKey("speech_config", MapUtil.of("voice_config", voiceConfig));
        return this.textToSpeech(prompt);
    }

    @Override
    public String uploadFile(File file) {
        if (null == file || !file.exists()) {
            throw new AIException("File not found!");
        }
        try {
            String mimeType = FileUtil.getMimeType(file.getName());
            if (StrUtil.isBlank(mimeType)) {
                mimeType = "application/octet-stream";
            }
            String uploadUrl = this.getUploadBaseUrl();
            String metadata = JSONUtil.toJsonStr(MapUtil.of("file", MapUtil.of("display_name", file.getName())));
            HttpResponse res = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post(uploadUrl).header("x-goog-api-key", this.config.getApiKey())).header("X-Goog-Upload-Protocol", "resumable")).header("X-Goog-Upload-Command", "start")).header("X-Goog-Upload-Header-Content-Length", String.valueOf(file.length()))).header("X-Goog-Upload-Header-Content-Type", mimeType)).body(metadata).execute();
            String sessionUrl = res.header("X-Goog-Upload-URL");
            HttpResponse uploadRes = ((HttpRequest)((HttpRequest)HttpRequest.put(sessionUrl).header("X-Goog-Upload-Command", "upload, finalize")).header("X-Goog-Upload-Offset", "0")).body(FileUtil.readBytes(file)).execute();
            return uploadRes.body();
        }
        catch (Exception e) {
            throw new AIException("Upload failed", e);
        }
    }

    @Override
    public byte[] addWavHeader(byte[] pcmData) {
        int totalDataLen = pcmData.length;
        int totalAudioLen = totalDataLen + 36;
        int sampleRate = 24000;
        boolean channels = true;
        int byteRate = 48000;
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalAudioLen & 0xFF), (byte)(totalAudioLen >> 8 & 0xFF), (byte)(totalAudioLen >> 16 & 0xFF), (byte)(totalAudioLen >> 24 & 0xFF), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, -64, 93, 0, 0, -128, -69, 0, 0, 2, 0, 16, 0, 100, 97, 116, 97, (byte)(totalDataLen & 0xFF), (byte)(totalDataLen >> 8 & 0xFF), (byte)(totalDataLen >> 16 & 0xFF), (byte)(totalDataLen >> 24 & 0xFF)};
        byte[] wavData = new byte[header.length + pcmData.length];
        System.arraycopy(header, 0, wavData, 0, header.length);
        System.arraycopy(pcmData, 0, wavData, header.length, pcmData.length);
        return wavData;
    }

    private String getUploadBaseUrl() {
        String apiUrl = this.config.getApiUrl();
        if (StrUtil.contains((CharSequence)apiUrl, "generativelanguage.googleapis.com")) {
            return "https://generativelanguage.googleapis.com/upload/v1beta/files";
        }
        try {
            URL url = new URL(apiUrl);
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "https://generativelanguage.googleapis.com/upload/v1beta/files").toString();
        }
        catch (Exception e) {
            return apiUrl.replace("/models/", "/upload/v1beta/files").split("/models")[0];
        }
    }

    private Map<String, Object> buildChatRequestMap(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList contents = new ArrayList();
        Map systemInstruction = null;
        for (Message msg : messages) {
            if ("system".equalsIgnoreCase(msg.getRole())) {
                systemInstruction = MapUtil.ofEntries(MapUtil.entry("parts", Collections.singletonList(MapUtil.ofEntries(MapUtil.entry("text", msg.getContent())))));
                continue;
            }
            contents.add(MapUtil.ofEntries(MapUtil.entry("role", "user".equalsIgnoreCase(msg.getRole()) ? "user" : "model"), MapUtil.entry("parts", Collections.singletonList(MapUtil.ofEntries(MapUtil.entry("text", msg.getContent()))))));
        }
        paramMap.put("contents", contents);
        if (ObjectUtil.isNotNull(systemInstruction)) {
            paramMap.put("system_instruction", systemInstruction);
        }
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private Map<String, Object> buildMultimodalRequestMap(String prompt, List<String> mediaList) {
        ArrayList parts = new ArrayList();
        parts.add(MapUtil.ofEntries(MapUtil.entry("text", prompt)));
        if (ObjectUtil.isNotNull(mediaList)) {
            for (String media : mediaList) {
                if (StrUtil.isBlank(media)) continue;
                if (media.contains("files/")) {
                    String fileUri = media;
                    if (!media.startsWith("http")) {
                        fileUri = "https://generativelanguage.googleapis.com/v1beta/" + media;
                    }
                    String realMimeType = this.getRemoteFileMimeType(fileUri);
                    parts.add(MapUtil.ofEntries(MapUtil.entry("file_data", MapUtil.ofEntries(MapUtil.entry("mime_type", realMimeType), MapUtil.entry("file_uri", fileUri)))));
                    continue;
                }
                if (media.startsWith("http")) {
                    try {
                        byte[] bytes = HttpUtil.downloadBytes(media);
                        String mime = FileUtil.getMimeType(media);
                        if (StrUtil.isBlank(mime)) {
                            mime = "image/jpeg";
                        }
                        parts.add(MapUtil.ofEntries(MapUtil.entry("inline_data", MapUtil.ofEntries(MapUtil.entry("mime_type", mime), MapUtil.entry("data", Base64.encode(bytes))))));
                        continue;
                    }
                    catch (Exception e) {
                        throw new AIException("Failed to download media from URL: " + media, e.getMessage());
                    }
                }
                parts.add(MapUtil.ofEntries(MapUtil.entry("inline_data", MapUtil.ofEntries(MapUtil.entry("mime_type", "image/jpeg"), MapUtil.entry("data", media)))));
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("contents", Collections.singletonList(MapUtil.ofEntries(MapUtil.entry("role", "user"), MapUtil.entry("parts", parts))));
        if (MapUtil.isNotEmpty(this.config.getAdditionalConfigMap())) {
            paramMap.putAll(this.config.getAdditionalConfigMap());
        }
        return paramMap;
    }

    private Map<String, Object> buildPredictVideoRequestMap(String prompt) {
        HashMap<String, String> instance = new HashMap<String, String>();
        instance.put("prompt", prompt);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("durationSeconds", GeminiCommon.GeminiDurationSeconds.EIGHT.getValue());
        Map<String, Object> additional = this.config.getAdditionalConfigMap();
        if (MapUtil.isNotEmpty(additional)) {
            parameters.putAll(additional);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("instances", Collections.singletonList(instance));
        paramMap.put("parameters", parameters);
        return paramMap;
    }

    private Map<String, Object> buildPredictImageRequestMap(String prompt) {
        HashMap<String, String> instance = new HashMap<String, String>();
        instance.put("prompt", prompt);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("sampleCount", GeminiCommon.GeminiImageCount.ONE.getCount());
        parameters.put("aspectRatio", GeminiCommon.GeminiAspectRatio.SQUARE.getRatio());
        parameters.put("personGeneration", GeminiCommon.GeminiPersonGeneration.ALLOW_ADULT.getValue());
        Map<String, Object> additional = this.config.getAdditionalConfigMap();
        if (MapUtil.isNotEmpty(additional)) {
            parameters.putAll(additional);
            if (additional.containsKey("numberOfImages")) {
                parameters.put("sampleCount", additional.get("numberOfImages"));
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("instances", Collections.singletonList(instance));
        paramMap.put("parameters", parameters);
        return paramMap;
    }

    private Map<String, Object> buildTextToSpeechRequestMap(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> part = new HashMap<String, String>();
        part.put("text", prompt);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("role", "user");
        content.put("parts", Collections.singletonList(part));
        paramMap.put("contents", Collections.singletonList(content));
        HashMap<String, Object> generationConfig = new HashMap<String, Object>();
        generationConfig.put("response_modalities", Collections.singletonList("AUDIO"));
        Map<String, Object> additionalMap = this.config.getAdditionalConfigMap();
        if (MapUtil.isNotEmpty(additionalMap)) {
            generationConfig.putAll(additionalMap);
        }
        paramMap.put("generation_config", generationConfig);
        return paramMap;
    }

    private String getRemoteFileMimeType(String fileUri) {
        try {
            String responseBody;
            JSONObject json;
            String mimeType;
            HttpRequest httpRequest = ((HttpRequest)((HttpRequest)HttpRequest.get(fileUri).header(Header.ACCEPT, "application/json")).header("x-goog-api-key", this.config.getApiKey())).timeout(this.config.getTimeout());
            if (this.config.getHasProxy()) {
                httpRequest.setProxy(this.config.getProxy());
            }
            if (StrUtil.isNotBlank(mimeType = (json = JSONUtil.parseObj(responseBody = httpRequest.execute().body())).getStr("mimeType"))) {
                return mimeType;
            }
        }
        catch (Exception e) {
            throw new AIException("Failed to get remote file MIME type", e.getMessage());
        }
        return "application/octet-stream";
    }

    @Override
    protected HttpResponse sendGet(String endpoint) {
        try {
            HttpRequest httpRequest = ((HttpRequest)((HttpRequest)HttpRequest.get(this.config.getApiUrl() + endpoint).header(Header.ACCEPT, "application/json")).header("x-goog-api-key", this.config.getApiKey())).timeout(this.config.getTimeout());
            if (this.config.getHasProxy()) {
                httpRequest.setProxy(this.config.getProxy());
            }
            return httpRequest.execute();
        }
        catch (Exception e) {
            throw new AIException("Failed to send GET request: " + e.getMessage(), e);
        }
    }

    @Override
    protected HttpResponse sendPost(String endpoint, String paramJson) {
        try {
            HttpRequest httpRequest = ((HttpRequest)((HttpRequest)HttpRequest.post(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "application/json")).header("x-goog-api-key", this.config.getApiKey())).body(paramJson).timeout(this.config.getTimeout());
            if (this.config.getHasProxy()) {
                httpRequest.setProxy(this.config.getProxy());
            }
            return httpRequest.execute();
        }
        catch (Exception e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendPostStream(String endpoint, Map<String, Object> paramMap, Consumer<String> callback) {
        HttpURLConnection connection = null;
        try {
            URL apiUrl = new URL(this.config.getApiUrl() + endpoint);
            connection = (HttpURLConnection)apiUrl.openConnection();
            if (this.config.getHasProxy()) {
                connection = (HttpURLConnection)apiUrl.openConnection(this.config.getProxy());
            }
            connection.setRequestMethod(Method.POST.name());
            connection.setRequestProperty(Header.CONTENT_TYPE.getValue(), "application/json");
            connection.setRequestProperty("x-goog-api-key", this.config.getApiKey());
            connection.setDoOutput(true);
            connection.setReadTimeout(this.config.getReadTimeout());
            connection.setConnectTimeout(this.config.getTimeout());
            try (OutputStream os = connection.getOutputStream();){
                String jsonInputString = JSONUtil.toJsonStr(paramMap);
                os.write(jsonInputString.getBytes());
                os.flush();
            }
            var7_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    callback.accept(line);
                }
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            callback.accept("{\"error\": \"" + e.getMessage() + "\"}");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

