/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    private static final Pattern COMPARE_REG = Pattern.compile("^[<>\u2265\u2264]=?");
    private static final String defaultVersionsDelimiter = ";";

    public static boolean anyMatch(String currentVersion, Collection<String> compareVersions) {
        return VersionUtil.matchEl(currentVersion, CollUtil.join(compareVersions, (CharSequence)defaultVersionsDelimiter));
    }

    public static boolean anyMatch(String currentVersion, String ... compareVersions) {
        return VersionUtil.matchEl(currentVersion, ArrayUtil.join(compareVersions, (CharSequence)defaultVersionsDelimiter));
    }

    public static boolean isGreaterThan(String currentVersion, String compareVersion) {
        return VersionUtil.matchEl(currentVersion, ">" + compareVersion);
    }

    public static boolean isGreaterThanOrEqual(String currentVersion, String compareVersion) {
        return VersionUtil.matchEl(currentVersion, ">=" + compareVersion);
    }

    public static boolean isLessThan(String currentVersion, String compareVersion) {
        return VersionUtil.matchEl(currentVersion, "<" + compareVersion);
    }

    public static boolean isLessThanOrEqual(String currentVersion, String compareVersion) {
        return VersionUtil.matchEl(currentVersion, "<=" + compareVersion);
    }

    public static boolean matchEl(String currentVersion, String versionEl) {
        return VersionUtil.matchEl(currentVersion, versionEl, defaultVersionsDelimiter);
    }

    public static boolean matchEl(String currentVersion, String versionEl, String versionsDelimiter) {
        if (StrUtil.isBlank(versionsDelimiter) || StrUtil.equals("-", versionsDelimiter) || ReUtil.isMatch(COMPARE_REG, (CharSequence)versionsDelimiter)) {
            throw new UtilException("\u975e\u6cd5\u7684\u7248\u672c\u5206\u9694\u7b26\uff1a" + versionsDelimiter);
        }
        if (StrUtil.isBlank(versionEl) || StrUtil.isBlank(currentVersion)) {
            return false;
        }
        String trimmedVersion = StrUtil.trim(currentVersion);
        List<String> els = StrUtil.split((CharSequence)versionEl, versionsDelimiter, true, true);
        if (CollUtil.isEmpty(els)) {
            return false;
        }
        block14: for (String el : els) {
            Matcher matcher = COMPARE_REG.matcher(el = el.trim());
            if (matcher.find()) {
                String op = matcher.group();
                String ver = StrUtil.removePrefix(el, op);
                switch (op) {
                    case ">=": 
                    case "\u2265": {
                        if (StrUtil.compareVersion(trimmedVersion, ver) < 0) continue block14;
                        return true;
                    }
                    case "<=": 
                    case "\u2264": {
                        if (StrUtil.compareVersion(trimmedVersion, ver) > 0) continue block14;
                        return true;
                    }
                    case "<": {
                        if (StrUtil.compareVersion(trimmedVersion, ver) >= 0) continue block14;
                        return true;
                    }
                    case ">": {
                        if (StrUtil.compareVersion(trimmedVersion, ver) <= 0) continue block14;
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (StrUtil.contains((CharSequence)el, "-")) {
                boolean rightMatch;
                int index = el.indexOf(45);
                String left = StrUtil.blankToDefault(StrUtil.trim(el.substring(0, index)), "");
                String right = StrUtil.blankToDefault(StrUtil.trim(el.substring(index + 1)), "");
                boolean leftMatch = StrUtil.isBlank(left) || StrUtil.compareVersion(left, trimmedVersion) <= 0;
                boolean bl = rightMatch = StrUtil.isBlank(right) || StrUtil.compareVersion(right, trimmedVersion) >= 0;
                if (!leftMatch || !rightMatch) continue;
                return true;
            }
            if (!Objects.equals(trimmedVersion, el)) continue;
            return true;
        }
        return false;
    }
}

