/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.function.Function;

public class BetweenFormatter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long betweenMs;
    private Level level;
    private final int levelMaxCount;
    private Function<Level, String> levelFormatter = Level::getName;
    private String separator = "";

    public BetweenFormatter(long betweenMs, Level level) {
        this(betweenMs, level, 0);
    }

    public BetweenFormatter(long betweenMs, Level level, int levelMaxCount) {
        this.betweenMs = betweenMs;
        this.level = level;
        this.levelMaxCount = levelMaxCount;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / DateUnit.DAY.getMillis();
            long hour = this.betweenMs / DateUnit.HOUR.getMillis() - day * 24L;
            long minute = this.betweenMs / DateUnit.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
            long BetweenOfSecond = ((day * 24L + hour) * 60L + minute) * 60L;
            long second = this.betweenMs / DateUnit.SECOND.getMillis() - BetweenOfSecond;
            long millisecond = this.betweenMs - (BetweenOfSecond + second) * 1000L;
            int level = this.level.ordinal();
            int levelCount = 0;
            if (this.isLevelCountValid(levelCount) && day > 0L) {
                sb.append(day).append(this.levelFormatter.apply(Level.DAY)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != hour && level >= Level.HOUR.ordinal()) {
                sb.append(hour).append(this.levelFormatter.apply(Level.HOUR)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != minute && level >= Level.MINUTE.ordinal()) {
                sb.append(minute).append(this.levelFormatter.apply(Level.MINUTE)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != second && level >= Level.SECOND.ordinal()) {
                sb.append(second).append(this.levelFormatter.apply(Level.SECOND)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != millisecond && level >= Level.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(this.levelFormatter.apply(Level.MILLISECOND)).append(this.separator);
            }
        }
        if (StrUtil.isEmpty(sb)) {
            sb.append(0).append(this.levelFormatter.apply(this.level));
        } else if (StrUtil.isNotEmpty(this.separator)) {
            sb.delete(sb.length() - this.separator.length(), sb.length());
        }
        return sb.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public void setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BetweenFormatter setLevelFormatter(Function<Level, String> levelFormatter) {
        this.levelFormatter = levelFormatter;
        return this;
    }

    public BetweenFormatter setSeparator(String separator) {
        this.separator = StrUtil.nullToEmpty(separator);
        return this;
    }

    public String toString() {
        return this.format();
    }

    private boolean isLevelCountValid(int levelCount) {
        return this.levelMaxCount <= 0 || levelCount < this.levelMaxCount;
    }

    public static enum Level {
        DAY("\u5929"),
        HOUR("\u5c0f\u65f6"),
        MINUTE("\u5206"),
        SECOND("\u79d2"),
        MILLISECOND("\u6beb\u79d2");

        private final String name;

        private Level(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

