/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.model.deepseek;

import cn.hutool.ai.core.AIConfig;
import cn.hutool.ai.core.BaseAIService;
import cn.hutool.ai.core.Message;
import cn.hutool.ai.model.deepseek.DeepSeekService;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DeepSeekServiceImpl
extends BaseAIService
implements DeepSeekService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String BETA_ENDPOINT = "/beta/completions";
    private final String MODELS_ENDPOINT = "/models";
    private final String BALANCE_ENDPOINT = "/user/balance";

    public DeepSeekServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(String prompt) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        return this.chat(messages);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        HttpResponse response = this.sendPost("/chat/completions", paramJson);
        return response.body();
    }

    @Override
    public String beta(String prompt) {
        String paramJson = this.buildBetaRequestBody(prompt);
        HttpResponse response = this.sendPost("/beta/completions", paramJson);
        return response.body();
    }

    @Override
    public String models() {
        HttpResponse response = this.sendGet("/models");
        return response.body();
    }

    @Override
    public String balance() {
        HttpResponse response = this.sendGet("/user/balance");
        return response.body();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildBetaRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }
}

