/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.impl.AbstractCache;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.core.collection.CopiedIter;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;

public abstract class StampedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    protected final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        long stamp = this.lock.readLock();
        try {
            CacheObj co = this.getWithoutLock(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        this.remove(key, true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        long stamp = this.lock.tryOptimisticRead();
        CacheObj co = this.getWithoutLock(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.getWithoutLock(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (null == co) {
            this.missCount.increment();
            return null;
        }
        if (!co.isExpired()) {
            this.hitCount.increment();
            return co.get(isUpdateLastAccess);
        }
        this.remove(key, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter copiedIterator;
        long stamp = this.lock.readLock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheObjIter());
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return new CacheObjIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void remove(K key) {
        this.remove(key, false);
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key, boolean withMissCount) {
        CacheObj co;
        long stamp = this.lock.writeLock();
        try {
            co = this.removeWithoutLock(key, withMissCount);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }
}

