/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final String name;

    public FileResource(String path) {
        this(FileUtil.file(path));
    }

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, null);
    }

    public FileResource(File file, String fileName) {
        Assert.notNull(file, "File must be not null !", new Object[0]);
        this.file = file;
        this.name = ObjectUtil.defaultIfNull(fileName, file.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return URLUtil.getURL(this.file);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        return FileUtil.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

