/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.StampedCache;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FIFOCache<K, V>
extends StampedCache<K, V> {
    private static final long serialVersionUID = 1L;

    public FIFOCache(int capacity) {
        this(capacity, 0L);
    }

    public FIFOCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap(capacity + 1, 1.0f, false);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj first = null;
        Iterator values = this.cacheMap.values().iterator();
        if (this.isPruneExpiredActive()) {
            while (values.hasNext()) {
                CacheObj co = (CacheObj)values.next();
                if (co.isExpired()) {
                    values.remove();
                    this.onRemove(co.key, co.obj);
                    ++count;
                    continue;
                }
                if (first != null) continue;
                first = co;
            }
        } else {
            CacheObj cacheObj = first = values.hasNext() ? (CacheObj)values.next() : null;
        }
        if (this.isFull() && null != first) {
            this.cacheMap.remove(first.key);
            this.onRemove(first.key, first.obj);
            ++count;
        }
        return count;
    }
}

