/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.cookie.GlobalCookieManager;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.CookieManager;
import java.net.HttpURLConnection;

public class HttpGlobalConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static int timeout = -1;
    private static boolean isAllowPatch = false;

    public static int getTimeout() {
        return timeout;
    }

    public static synchronized void setTimeout(int customTimeout) {
        timeout = customTimeout;
    }

    public static CookieManager getCookieManager() {
        return GlobalCookieManager.getCookieManager();
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        GlobalCookieManager.setCookieManager(customCookieManager);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    public static synchronized void allowPatch() {
        if (isAllowPatch) {
            return;
        }
        Field methodsField = ReflectUtil.getField(HttpURLConnection.class, "methods");
        if (null == methodsField) {
            throw new HttpException("None static field [methods] with Java version: [{}]", System.getProperty("java.version"));
        }
        ReflectUtil.setFieldValue((Object)methodsField, "modifiers", (Object)(methodsField.getModifiers() & 0xFFFFFFEF));
        String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"};
        ReflectUtil.setFieldValue(null, methodsField, (Object)methods);
        Object staticFieldValue = ReflectUtil.getStaticFieldValue(methodsField);
        if (!ArrayUtil.equals(methods, staticFieldValue)) {
            throw new HttpException("Inject value to field [methods] failed!");
        }
        isAllowPatch = true;
    }
}

