/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.PinyinComparator;
import cn.hutool.core.comparator.PropertyComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListUtil {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return ListUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return ListUtil.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListUtil.list(isLinked);
        }
        return ListUtil.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListUtil.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list = ListUtil.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)ListUtil.list(false, values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        return (LinkedList)ListUtil.list(true, values);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ListUtil.toList(ts));
    }

    public static <T> CopyOnWriteArrayList<T> toCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return (ArrayList)ListUtil.list(false, collection);
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        return (ArrayList)ListUtil.list(false, iterable);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        return (ArrayList)ListUtil.list(false, iterator);
    }

    public static <T> ArrayList<T> toList(Enumeration<T> enumeration) {
        return (ArrayList)ListUtil.list(false, enumeration);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo < PageUtil.getFirstPageNo() + 1) {
                return Collections.unmodifiableList(list);
            }
            return new ArrayList(0);
        }
        if ((long)(pageNo - PageUtil.getFirstPageNo()) * (long)pageSize > (long)resultSize) {
            return new ArrayList(0);
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
            if (startEnd[0] > startEnd[1]) {
                return ListUtil.empty();
            }
        }
        return list.subList(startEnd[0], startEnd[1]);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        list.sort(c);
        return list;
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtil.sort(list, new PropertyComparator(property));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sort(list, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectUtil.clone(list);
        return ListUtil.reverse(list2);
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListUtil.sub(list, start, end, 1);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 1) {
            return list.subList(start, end);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> List<T> filter(List<T> list, Editor<T> editor) {
        if (null == list || null == editor) {
            return list;
        }
        AbstractList list2 = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (T t : list) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list2.add(modified);
        }
        return list2;
    }

    public static <T> int[] indexOfAll(List<T> list, Matcher<T> matcher) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != list) {
            int index = 0;
            for (T t : list) {
                if (null == matcher || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, indexList);
    }

    public static <T> List<T> unmodifiable(List<T> list) {
        if (null == list) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<List<T>> split(List<T> list, int size) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        int listSize = list.size();
        ArrayList<List<T>> result = new ArrayList<List<T>>(listSize / size + 1);
        int offset = 0;
        for (int toIdx = size; toIdx <= listSize; toIdx += size) {
            result.add(list.subList(offset, toIdx));
            offset = toIdx;
        }
        if (offset < listSize) {
            result.add(list.subList(offset, listSize));
        }
        return result;
    }
}

