/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.db.Entity;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HandleHelper {
    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, T bean) throws SQLException {
        return HandleHelper.handleRow(columnCount, meta, rs).toBeanIgnoreCase(bean);
    }

    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, Class<T> beanClass) throws SQLException {
        Assert.notNull(beanClass, "Bean Class must be not null !", new Object[0]);
        if (beanClass.isArray()) {
            Class<?> componentType = beanClass.getComponentType();
            T[] result = ArrayUtil.newArray(componentType, columnCount);
            int i = 0;
            int j = 1;
            while (i < columnCount) {
                result[i] = HandleHelper.getColumnValue(rs, j, meta.getColumnType(j), componentType);
                ++i;
                ++j;
            }
            return (T)result;
        }
        if (Iterable.class.isAssignableFrom(beanClass)) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return Convert.convert(beanClass, (Object)objRow);
        }
        if (beanClass.isAssignableFrom(Entity.class)) {
            return (T)HandleHelper.handleRow(columnCount, meta, rs);
        }
        if (String.class == beanClass) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return (T)StrUtil.join(", ", objRow);
        }
        T bean = ReflectUtil.newInstanceIfPossible(beanClass);
        Map<String, PropDesc> propMap = BeanUtil.getBeanDesc(beanClass).getPropMap(true);
        for (int i = 1; i <= columnCount; ++i) {
            Method setter;
            String columnLabel = meta.getColumnLabel(i);
            PropDesc pd = propMap.get(columnLabel);
            if (null == pd) {
                pd = propMap.get(StrUtil.toCamelCase(columnLabel));
            }
            Method method = setter = null == pd ? null : pd.getSetter();
            if (null == setter) continue;
            Object value = HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), TypeUtil.getFirstParamType(setter));
            ReflectUtil.invokeWithCheck(bean, setter, value);
        }
        return bean;
    }

    public static Entity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        return HandleHelper.handleRow(columnCount, meta, rs, false);
    }

    public static Entity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, boolean caseInsensitive) throws SQLException {
        return HandleHelper.handleRow(new Entity(null, caseInsensitive), columnCount, meta, rs, true);
    }

    public static <T extends Entity> T handleRow(T row, int columnCount, ResultSetMetaData meta, ResultSet rs, boolean withMetaInfo) throws SQLException {
        for (int i = 1; i <= columnCount; ++i) {
            int type = meta.getColumnType(i);
            row.put(meta.getColumnLabel(i), HandleHelper.getColumnValue(rs, i, type, null));
        }
        if (withMetaInfo) {
            row.setTableName(meta.getTableName(1));
            row.setFieldNames(row.keySet());
        }
        return row;
    }

    public static Entity handleRow(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        return HandleHelper.handleRow(columnCount, meta, rs);
    }

    public static List<Object> handleRowToList(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            row.add(HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), null));
        }
        return row;
    }

    public static <T extends Collection<Entity>> T handleRs(ResultSet rs, T collection) throws SQLException {
        return HandleHelper.handleRs(rs, collection, false);
    }

    public static <T extends Collection<Entity>> T handleRs(ResultSet rs, T collection, boolean caseInsensitive) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add((Entity)HandleHelper.handleRow(columnCount, meta, rs, caseInsensitive));
        }
        return collection;
    }

    public static <E, T extends Collection<E>> T handleRsToBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add(HandleHelper.handleRow(columnCount, meta, rs, elementBeanType));
        }
        return collection;
    }

    private static <T> Object getColumnValue(ResultSet rs, int columnIndex, int type, Type targetColumnType) throws SQLException {
        Object rawValue = null;
        switch (type) {
            case 93: {
                try {
                    rawValue = rs.getTimestamp(columnIndex);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 92: {
                rawValue = rs.getTime(columnIndex);
                break;
            }
            default: {
                rawValue = rs.getObject(columnIndex);
            }
        }
        if (null == targetColumnType || Object.class == targetColumnType) {
            return rawValue;
        }
        return Convert.convert(targetColumnType, rawValue);
    }
}

