/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin.engine.pinyin4j;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.PinyinException;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Pinyin4jEngine
implements PinyinEngine {
    HanyuPinyinOutputFormat format;

    public Pinyin4jEngine() {
        this(null);
    }

    public Pinyin4jEngine(HanyuPinyinOutputFormat format) {
        this.init(format);
    }

    public void init(HanyuPinyinOutputFormat format) {
        if (null == format) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        String result;
        try {
            String[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayUtil.isEmpty(results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String str, String separator) {
        try {
            return PinyinHelper.toHanYuPinyinString((String)str, (HanyuPinyinOutputFormat)this.format, (String)separator, (boolean)true);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new PinyinException(e);
        }
    }
}

