/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    protected static Writer writeValue(Writer writer, Object value, int indentFactor, int indent, JSONConfig config) throws JSONException, IOException {
        if (value == null || value instanceof JSONNull) {
            writer.write(JSONNull.NULL.toString());
        } else if (value instanceof JSON) {
            ((JSON)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject(value).write(writer, indentFactor, indent);
        } else if (value instanceof Iterable || value instanceof Iterator || value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(NumberUtil.toStr((Number)value));
        } else if (value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor) {
            String format = null == config ? null : config.getDateFormat();
            writer.write(InternalJSONUtil.formatDate(value, format));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONString) {
            String valueStr;
            try {
                valueStr = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(valueStr != null ? valueStr : JSONUtil.quote(value.toString()));
        } else {
            JSONUtil.quote(value.toString(), writer);
        }
        return writer;
    }

    protected static void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    protected static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    protected static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    protected static Object stringToValue(String string) {
        if (null == string || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    double d = Double.parseDouble(string);
                    if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    protected static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value) {
        String keyStr = Convert.toStr(key);
        String[] path = StrUtil.split((CharSequence)keyStr, ".");
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject();
                target.put(segment, (Object)nextTarget);
            }
            target = nextTarget;
        }
        target.put(path[last], value);
        return jsonObject;
    }

    protected static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    private static String formatDate(Object dateObj, String format) {
        long timeMillis;
        if (StrUtil.isNotBlank(format)) {
            return JSONUtil.quote(DateUtil.format(Convert.toDate(dateObj), format));
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = DateUtil.toInstant((TemporalAccessor)dateObj).toEpochMilli();
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            throw new UnsupportedOperationException("Unsupported Date type: " + dateObj.getClass());
        }
        return String.valueOf(timeMillis);
    }
}

