/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.servlet.multipart;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.multipart.MultipartRequestInputStream;
import cn.hutool.extra.servlet.multipart.UploadFileHeader;
import cn.hutool.extra.servlet.multipart.UploadSetting;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadFile {
    private static Log log = LogFactory.get();
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private UploadFileHeader header;
    private UploadSetting setting;
    private int size = -1;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        this.header = header;
        this.setting = setting;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String destPath) throws IOException {
        if (this.data != null || this.tempFile != null) {
            return this.write(FileUtil.touch(destPath));
        }
        return null;
    }

    public File write(File destination) throws IOException {
        this.assertValid();
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes(this.data, destination);
            this.data = null;
        } else if (this.tempFile != null) {
            FileUtil.move(this.tempFile, destination, true);
        }
        return destination;
    }

    public byte[] getFileContent() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes(this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.data));
        }
        if (this.tempFile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public int size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        if (!this.isAllowedExtension()) {
            log.debug("Forbidden uploaded file [{}]", this.getFileName());
            this.size = input.skipToBoundary();
            return false;
        }
        this.size = 0;
        int memoryThreshold = this.setting.memoryThreshold;
        if (memoryThreshold > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
            int written = input.copy(baos, memoryThreshold);
            this.data = baos.toByteArray();
            if (written <= memoryThreshold) {
                this.size = this.data.length;
                return true;
            }
        }
        this.tempFile = FileUtil.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, FileUtil.touch(this.setting.tmpUploadPath), false);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        if (this.data != null) {
            this.size = this.data.length;
            out.write(this.data);
            this.data = null;
        }
        int maxFileSize = this.setting.maxFileSize;
        try {
            if (maxFileSize == -1) {
                this.size += input.copy(out);
                boolean bl = true;
                return bl;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1);
            if (this.size > maxFileSize) {
                this.tempFile.delete();
                this.tempFile = null;
                log.debug("Upload file [{}] too big, file size > [{}]", this.getFileName(), maxFileSize);
                input.skipToBoundary();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IoUtil.close(out);
        }
        return true;
    }

    private boolean isAllowedExtension() {
        String[] exts = this.setting.fileExts;
        boolean isAllow = this.setting.isAllowFileExts;
        if (exts == null || exts.length == 0) {
            return isAllow;
        }
        String fileNameExt = FileUtil.extName(this.getFileName());
        for (String fileExtension : this.setting.fileExts) {
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return !isAllow;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format((CharSequence)"File [{}] upload fail", this.getFileName()));
        }
    }
}

