/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.IndexedComparator;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.poi.excel.ExcelBase;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.WorkbookUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.Align;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    protected File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private boolean onlyAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet = new StyleSet(this.workbook);

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorkbookUtil.createBook(isXlsx), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(WorkbookUtil.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file(destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(WorkbookUtil.createBookForWriter(destFile), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(WorkbookUtil.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetIndex);
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetName);
    }

    public ExcelWriter reset() {
        this.resetRow();
        this.aliasComparator = null;
        return this;
    }

    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex) {
        this.sheet.autoSizeColumn(columnIndex);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public ExcelWriter disableDefaultStyle() {
        return this.setStyleSet(null);
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public String getDisposition(String fileName, Charset charset) {
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        if (StrUtil.isBlank(fileName)) {
            fileName = IdUtil.fastSimpleUUID();
        }
        fileName = StrUtil.addSuffixIfNot(URLUtil.encodeAll(fileName, charset), this.isXlsx() ? ".xlsx" : ".xls");
        return StrUtil.format((CharSequence)"attachment; filename=\"{}\"; filename*={}''{}", fileName, charset.name(), fileName);
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter clearHeaderAlias() {
        this.headerAlias = null;
        return this;
    }

    public ExcelWriter setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriter addHeaderAlias(String name, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        headerAlias.put(name, alias);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rownum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        return this.addSelect(new CellRangeAddressList(y, y, x, x), selectList);
    }

    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])selectList);
        HSSFDataValidation dataValidation = null;
        if (this.sheet instanceof XSSFSheet) {
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper((XSSFSheet)this.sheet);
            XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(selectList);
            dataValidation = dvHelper.createValidation((DataValidationConstraint)dvConstraint, regions);
        } else {
            dataValidation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        }
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowErrorBox(true);
        return this.addValidationData((DataValidation)dataValidation);
    }

    public ExcelWriter addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int rowIndex = this.currentRow.get();
        this.merge(rowIndex, rowIndex, 0, lastColumn, content, isSetHeaderStyle);
        if (null != content) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        CellStyle style = isSetHeaderStyle && null != this.styleSet && null != this.styleSet.headCellStyle ? this.styleSet.headCellStyle : this.styleSet.cellStyle;
        CellUtil.mergingCells(this.sheet, firstRow, lastRow, firstColumn, lastColumn, style);
        if (null != content) {
            Cell cell = this.getOrCreateCell(firstColumn, firstRow);
            CellUtil.setCellValue(cell, content, this.styleSet, isSetHeaderStyle);
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map<String, Object> map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = BeanUtil.beanToMap(obj, new TreeMap<String, Object>(comparator), false, false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, true);
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        if (rowBean instanceof Iterable) {
            return this.writeRow((Iterable)rowBean);
        }
        Map<String, Object> rowMap = null;
        if (rowBean instanceof Map) {
            rowMap = MapUtil.isNotEmpty(this.headerAlias) ? MapUtil.newTreeMap((Map)rowBean, this.getInitedAliasComparator()) : (TreeMap)rowBean;
        } else if (BeanUtil.isBean(rowBean.getClass())) {
            rowMap = MapUtil.isEmpty(this.headerAlias) ? BeanUtil.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false) : BeanUtil.beanToMap(rowBean, new TreeMap<String, Object>(this.getInitedAliasComparator()), false, false);
        } else {
            return this.writeRow(CollUtil.newArrayList(rowBean), isWriteKeyAsHead);
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (MapUtil.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        Map<?, ?> aliasMap = this.aliasMap(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeadRow(aliasMap.keySet());
        }
        this.writeRow(aliasMap.values());
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, false);
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Cell cell = this.getOrCreateCell(x, y);
        CellUtil.setCellValue(cell, value, this.styleSet, false);
        return this;
    }

    @Deprecated
    public CellStyle createStyleForCell(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(style);
        return this;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public ExcelWriter flush() throws IORuntimeException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws IORuntimeException {
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(FileUtil.getOutputStream(destFile), true);
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        return this.flush(out, false);
    }

    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow = null;
        this.styleSet = null;
    }

    private Map<?, ?> aliasMap(Map<?, ?> rowMap) {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return rowMap;
        }
        LinkedHashMap filteredMap = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : rowMap.entrySet()) {
            String aliasName = this.headerAlias.get(entry.getKey());
            if (null != aliasName) {
                filteredMap.put(aliasName, entry.getValue());
                continue;
            }
            if (this.onlyAlias) continue;
            filteredMap.put((String)entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    private Comparator<String> getInitedAliasComparator() {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set<String> keySet = this.headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[keySet.size()]));
        }
        return aliasComparator;
    }
}

