/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.Mail;
import cn.hutool.extra.mail.MailAccount;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class MailUtil {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), MailUtil.splitAddress(cc), MailUtil.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(tos, null, null, subject, content, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), true, tos, ccs, bccs, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, false, tos, ccs, bccs, subject, content, isHtml, files);
    }

    private static void send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount).setUseGlobalSession(useGlobalSession);
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[ccs.size()]));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[bccs.size()]));
        }
        mail.setTos(tos.toArray(new String[tos.size()]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StrUtil.isBlank(addresses)) {
            return null;
        }
        List<String> result = StrUtil.contains(addresses, ',') ? StrUtil.splitTrim((CharSequence)addresses, ',') : (StrUtil.contains(addresses, ';') ? StrUtil.splitTrim((CharSequence)addresses, ';') : CollUtil.newArrayList(addresses));
        return result;
    }
}

