/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

public class CacheObj<K, V> {
    protected final K key;
    protected final V obj;
    private long lastAccess;
    protected long accessCount;
    private long ttl;

    protected CacheObj(K key, V obj, long ttl) {
        this.key = key;
        this.obj = obj;
        this.ttl = ttl;
        this.lastAccess = System.currentTimeMillis();
    }

    boolean isExpired() {
        long expiredTime;
        return this.ttl > 0L && (expiredTime = this.lastAccess + this.ttl) > 0L && expiredTime < System.currentTimeMillis();
    }

    V get(boolean isUpdateLastAccess) {
        if (isUpdateLastAccess) {
            this.lastAccess = System.currentTimeMillis();
        }
        ++this.accessCount;
        return this.obj;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.obj;
    }

    public String toString() {
        return "CacheObj [key=" + this.key + ", obj=" + this.obj + ", lastAccess=" + this.lastAccess + ", accessCount=" + this.accessCount + ", ttl=" + this.ttl + "]";
    }
}

