/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Sftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(JschUtil.getSession(sshHost, sshPort, sshUser, sshPass), charset);
    }

    public Sftp(Session session) {
        this(session, DEFAULT_CHARSET);
    }

    public Sftp(Session session, Charset charset) {
        this(JschUtil.openSftp(session), charset);
        this.session = session;
    }

    public Sftp(ChannelSftp channel, Charset charset) {
        this.charset = charset;
        this.channel = channel;
        try {
            this.channel.setFilenameEncoding(charset.toString());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public ChannelSftp getClient() {
        return this.channel;
    }

    @Deprecated
    public ChannelSftp getChannel() {
        return this.getClient();
    }

    @Override
    public String pwd() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public String home() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return this.ls(path, null);
    }

    public List<String> lsDirs(String path) {
        return this.ls(path, new Filter<ChannelSftp.LsEntry>(){

            @Override
            public boolean accept(ChannelSftp.LsEntry t) {
                return t.getAttrs().isDir();
            }
        });
    }

    public List<String> lsFiles(String path) {
        return this.ls(path, new Filter<ChannelSftp.LsEntry>(){

            @Override
            public boolean accept(ChannelSftp.LsEntry t) {
                return false == t.getAttrs().isDir();
            }
        });
    }

    public List<String> ls(String path, final Filter<ChannelSftp.LsEntry> filter) {
        final ArrayList<String> fileNames = new ArrayList<String>();
        try {
            this.channel.ls(path, new ChannelSftp.LsEntrySelector(){

                public int select(ChannelSftp.LsEntry entry) {
                    String fileName = entry.getFilename();
                    if (!(StrUtil.equals(".", fileName) || StrUtil.equals("..", fileName) || null != filter && !filter.accept(entry))) {
                        fileNames.add(entry.getFilename());
                    }
                    return 0;
                }
            });
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return fileNames;
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.channel.mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    @Override
    public boolean cd(String directory) {
        if (StrUtil.isBlank(directory)) {
            return false;
        }
        try {
            this.channel.cd(directory.replaceAll("\\\\", "/"));
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    public boolean delFile(String filePath) {
        try {
            this.channel.rm(filePath);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean delDir(String dirPath) {
        if (!this.cd(dirPath)) {
            return false;
        }
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            this.channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    @Override
    public boolean upload(String srcFilePath, File destFile) {
        this.put(srcFilePath, FileUtil.getAbsolutePath(destFile));
        return true;
    }

    public Sftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        try {
            this.channel.put(srcFilePath, destPath, mode.ordinal());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    @Override
    public void download(String src, File destFile) {
        this.get(src, FileUtil.getAbsolutePath(destFile));
    }

    public Sftp get(String src, String dest) {
        try {
            this.channel.get(src, dest);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        JschUtil.close((Channel)this.channel);
        JschUtil.close(this.session);
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

