/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.cache.impl.CacheValuesIterator;
import cn.hutool.core.collection.CopiedIter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObj<K, V>> cacheMap;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.writeLock.lock();
        try {
            CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (co.isExpired()) {
                this.removeWithoutLock(key);
                ++this.missCount;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    @Override
    public V get(K key) {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this.removeWithoutLock(key);
                ++this.missCount;
                V v = null;
                return v;
            }
            ++this.hitCount;
            V v = co.get(isUpdateLastAccess);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter<CacheObj<K, V>> copiedIterator;
        this.readLock.lock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheMap.values().iterator());
        }
        finally {
            this.readLock.unlock();
        }
        return new CacheObjIterator<K, V>(copiedIterator);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        this.writeLock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        CacheObj<K, V> co;
        this.writeLock.lock();
        try {
            co = this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    protected void onRemove(K key, V cachedObject) {
    }

    private void removeWithoutLock(K key) {
        CacheObj<K, V> co = this.cacheMap.remove(key);
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }
}

