/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.poi.excel.sax.AbstractExcelSaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class Excel03SaxReader
extends AbstractExcelSaxReader<Excel03SaxReader>
implements HSSFListener {
    private boolean isOutputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private boolean isOutputNextStringRecord;
    private List<Object> rowCellList = new ArrayList<Object>();
    private int sheetIndex = -1;
    private int curSheetIndex = -1;
    private RowHandler rowHandler;

    public Excel03SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    @Override
    public Excel03SaxReader read(File file, int sheetIndex) throws POIException {
        try {
            return this.read(new POIFSFileSystem(file), sheetIndex);
        }
        catch (IOException e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel03SaxReader read(InputStream excelStream, int sheetIndex) throws POIException {
        try {
            return this.read(new POIFSFileSystem(excelStream), sheetIndex);
        }
        catch (IOException e) {
            throw new POIException(e);
        }
    }

    public Excel03SaxReader read(POIFSFileSystem fs, int sheetIndex) throws POIException {
        this.sheetIndex = sheetIndex;
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
        HSSFRequest request = new HSSFRequest();
        if (this.isOutputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        HSSFEventFactory factory = new HSSFEventFactory();
        try {
            factory.processWorkbookEvents(request, fs);
        }
        catch (IOException e) {
            throw new POIException(e);
        }
        return this;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getSheetName() {
        if (this.boundSheetRecords.size() > this.sheetIndex) {
            return this.boundSheetRecords.get(this.sheetIndex > -1 ? this.sheetIndex : this.curSheetIndex).getSheetname();
        }
        return null;
    }

    public void processRecord(Record record) {
        if (this.sheetIndex > -1 && this.curSheetIndex > this.sheetIndex) {
            return;
        }
        if (record instanceof BoundSheetRecord) {
            this.boundSheetRecords.add((BoundSheetRecord)record);
        } else if (record instanceof SSTRecord) {
            this.sstRecord = (SSTRecord)record;
        } else if (record instanceof BOFRecord) {
            BOFRecord bofRecord = (BOFRecord)record;
            if (bofRecord.getType() == 16) {
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.curSheetIndex;
            }
        } else if (this.isProcessCurrentSheet()) {
            if (record instanceof MissingCellDummyRecord) {
                MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
                this.rowCellList.add(mc.getColumn(), "");
            } else if (record instanceof LastCellOfRowDummyRecord) {
                this.processLastCell((LastCellOfRowDummyRecord)record);
            } else {
                this.processCellValue(record);
            }
        }
    }

    private void processCellValue(Record record) {
        Object value = null;
        switch (record.getSid()) {
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                this.rowCellList.add(brec.getColumn(), "");
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                this.rowCellList.add(berec.getColumn(), berec.getBooleanValue());
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                if (this.isOutputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.isOutputNextStringRecord = true;
                    } else {
                        value = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                    }
                } else {
                    value = '\"' + HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression()) + '\"';
                }
                this.rowCellList.add(frec.getColumn(), value);
                break;
            }
            case 519: {
                if (!this.isOutputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                value = srec.getString();
                this.isOutputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                this.rowCellList.add(lrec.getColumn(), value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                if (this.sstRecord == null) {
                    this.rowCellList.add(lsrec.getColumn(), "");
                    break;
                }
                value = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                this.rowCellList.add(lsrec.getColumn(), value);
                break;
            }
            case 515: {
                double numValue;
                long longPart;
                NumberRecord numrec = (NumberRecord)record;
                String formatString = this.formatListener.getFormatString((CellValueRecordInterface)numrec);
                value = formatString.contains(".") ? Double.valueOf(numrec.getValue()) : (formatString.contains("/") || formatString.contains(":") ? this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec) : Double.valueOf((double)(longPart = (long)(numValue = numrec.getValue())) == numValue ? (double)longPart : numValue));
                this.rowCellList.add(numrec.getColumn(), value);
                break;
            }
        }
    }

    private void processLastCell(LastCellOfRowDummyRecord lastCell) {
        this.rowHandler.handle(this.curSheetIndex, lastCell.getRow(), this.rowCellList);
        this.rowCellList.clear();
    }

    private boolean isProcessCurrentSheet() {
        return this.sheetIndex < 0 || this.curSheetIndex == this.sheetIndex;
    }
}

