/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONStrFormater;
import cn.hutool.json.JSONString;
import cn.hutool.json.XML;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public final class JSONUtil {
    public static JSONObject createObj() {
        return new JSONObject();
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONObject parseObj(String jsonStr) {
        return new JSONObject(jsonStr);
    }

    public static JSONObject parseObj(Object obj) {
        return new JSONObject(obj);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        return new JSONObject(obj, ignoreNullValue);
    }

    public static JSONArray parseArray(String jsonStr) {
        return new JSONArray(jsonStr);
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return new JSONArray(arrayOrCollection);
    }

    public static JSONArray parseArray(Object arrayOrCollection, boolean ignoreNullValue) {
        return new JSONArray(arrayOrCollection, ignoreNullValue);
    }

    public static JSON parse(Object obj) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        Object json = null;
        json = obj instanceof JSON ? (JSON)obj : (obj instanceof String ? ((jsonStr = ((String)obj).trim()).startsWith("[") ? JSONUtil.parseArray(jsonStr) : JSONUtil.parseObj(jsonStr)) : (obj instanceof Collection || obj.getClass().isArray() ? new JSONArray(obj) : new JSONObject(obj)));
        return json;
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return XML.toJSONObject(xmlStr);
    }

    public static JSONObject parseFromMap(Map<?, ?> map) {
        return new JSONObject(map);
    }

    public static JSONObject parseFromResourceBundle(ResourceBundle bundle) {
        JSONObject jsonObject = new JSONObject();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(jsonObject, key, bundle.getString(key));
        }
        return jsonObject;
    }

    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parse(FileReader.create(file, charset).readString());
    }

    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseObj(FileReader.create(file, charset).readString());
    }

    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseArray(FileReader.create(file, charset).readString());
    }

    public static String toJsonStr(JSON json, int indentFactor) {
        return json.toJSONString(indentFactor);
    }

    public static String toJsonStr(JSON json) {
        return json.toJSONString(0);
    }

    public static String toJsonPrettyStr(JSON json) {
        return json.toJSONString(4);
    }

    public static String toJsonStr(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return JSONUtil.toJsonStr(JSONUtil.parse(obj));
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.toJsonPrettyStr(JSONUtil.parse(obj));
    }

    public static String toXmlStr(JSON json) {
        return XML.toXml(json);
    }

    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        return JSONUtil.toBean(JSONUtil.parseObj(jsonString), beanClass, false);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass) {
        return JSONUtil.toBean(json, beanClass, false);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass, boolean ignoreError) {
        return (T)(null == json ? null : json.toBean(beanClass, ignoreError));
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return null == jsonArray ? null : jsonArray.toList(elementType);
    }

    @Deprecated
    public static Object getByExp(JSON json, String expression) {
        return null == json || StrUtil.isBlank(expression) ? null : json.getByPath(expression);
    }

    public static Object getByPath(JSON json, String expression) {
        return null == json || StrUtil.isBlank(expression) ? null : json.getByPath(expression);
    }

    public static void putByPath(JSON json, String expression, Object value) {
        json.putByPath(expression, value);
    }

    public static String quote(String string) {
        return JSONUtil.quote(string, true);
    }

    public static String quote(String string, boolean isWrap) {
        StringWriter sw = new StringWriter();
        try {
            return JSONUtil.quote(string, sw, isWrap).toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public static Writer quote(String str, Writer writer) throws IOException {
        return JSONUtil.quote(str, writer, true);
    }

    public static Writer quote(String str, Writer writer, boolean isWrap) throws IOException {
        if (StrUtil.isEmpty(str)) {
            if (isWrap) {
                writer.write("\"\"");
            }
            return writer;
        }
        char c = '\u0000';
        int len = str.length();
        if (isWrap) {
            writer.write(34);
        }
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write("\\");
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write(HexUtil.toUnicodeHex(c));
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        if (isWrap) {
            writer.write(34);
        }
        return writer;
    }

    public static String escape(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    builder.append("\\b");
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block7;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block7;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
                        builder.append(HexUtil.toUnicodeHex(c));
                        continue block7;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static Object wrap(Object object, boolean ignoreNullValue) {
        if (object == null) {
            return JSONNull.NULL;
        }
        if (object instanceof JSON || JSONNull.NULL.equals(object) || object instanceof JSONString || object instanceof CharSequence || object instanceof Number || ObjectUtil.isBasicType(object)) {
            return object;
        }
        try {
            String objectPackageName;
            if (object instanceof Iterable || ArrayUtil.isArray(object)) {
                return new JSONArray(object, ignoreNullValue);
            }
            if (object instanceof Map) {
                return new JSONObject(object, ignoreNullValue);
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTimeInMillis();
            }
            if (object instanceof Enum) {
                return object.toString();
            }
            Class<?> objectClass = object.getClass();
            Package objectPackage = objectClass.getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || objectClass.getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object, ignoreNullValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormater.format(jsonStr);
    }

    public static boolean isJson(String str) {
        return JSONUtil.isJsonObj(str) || JSONUtil.isJsonArray(str);
    }

    public static boolean isJsonObj(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)str.trim(), '{', '}');
    }

    public static boolean isJsonArray(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)str.trim(), '[', ']');
    }

    public static JSONObject xmlToJson(String xml) {
        return XML.toJSONObject(xml);
    }
}

