/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.druid;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.setting.Setting;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DruidDSFactory
extends DSFactory {
    public static final String DS_NAME = "Druid";
    private Map<String, DruidDataSource> dsMap = new ConcurrentHashMap<String, DruidDataSource>();

    public DruidDSFactory() {
        this(null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DruidDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DruidDataSource dds;
        if (group == null) {
            group = "";
        }
        if ((dds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)dds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<DruidDataSource> values = this.dsMap.values();
            for (DruidDataSource dds : values) {
                IoUtil.close((Closeable)dds);
            }
            this.dsMap.clear();
        }
    }

    private DruidDataSource createDataSource(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Druid config for group: [{}]", group);
        }
        DruidDataSource ds = new DruidDataSource();
        String url = config.getAndRemoveStr(KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        ds.setUrl(url);
        ds.setUsername(config.getAndRemoveStr(KEY_ALIAS_USER));
        ds.setPassword(config.getAndRemoveStr(KEY_ALIAS_PASSWORD));
        String driver = config.getAndRemoveStr(KEY_ALIAS_DRIVER);
        if (StrUtil.isNotBlank(driver)) {
            ds.setDriverClassName(driver);
        }
        Properties config2 = new Properties();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String keyStr = StrUtil.addPrefixIfNot(entry.getKey(), "druid.");
            config2.put(keyStr, entry.getValue());
        }
        ds.configFromPropety(config2);
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

