/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Holder;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReUtil {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESES = "[\u4e00-\u9fff]+";
    public static final Set<Character> RE_KEYS = CollectionUtil.newHashSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static String getGroup0(String regex, String content) {
        return ReUtil.get(regex, content, 0);
    }

    public static String getGroup1(String regex, String content) {
        return ReUtil.get(regex, content, 1);
    }

    public static String get(String regex, String content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.get(pattern, content, groupIndex);
    }

    public static String getGroup0(Pattern pattern, String content) {
        return ReUtil.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, String content) {
        return ReUtil.get(pattern, content, 1);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static List<String> getAllGroups(Pattern pattern, String content) {
        return ReUtil.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, String content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, String content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return ObjectUtil.compare(o2, o1);
            }
        });
        Matcher matcherForTemplate = PatternPool.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, String content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder<String> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = ReUtil.findAll(PatternPool.GROUP_VAR, template, 1, new HashSet());
        String content = (String)contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StrUtil.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Holder<String> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(String regex, String content) {
        if (StrUtil.hasBlank(regex, content)) {
            return content;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.delFirst(pattern, content);
    }

    public static String delFirst(Pattern pattern, String content) {
        if (null == pattern || StrUtil.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceFirst("");
    }

    public static String delAll(String regex, String content) {
        if (StrUtil.hasBlank(regex, content)) {
            return content;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.delAll(pattern, content);
    }

    public static String delAll(Pattern pattern, String content) {
        if (null == pattern || StrUtil.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delPre(String regex, String content) {
        if (null == content || null == regex) {
            return content;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StrUtil.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static List<String> findAllGroup0(String regex, String content) {
        return ReUtil.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, String content) {
        return ReUtil.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, String content, int group) {
        return ReUtil.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        if (null == regex) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.findAll(pattern, content, group, collection);
    }

    public static List<String> findAllGroup0(Pattern pattern, String content) {
        return ReUtil.findAll(pattern, content, 0);
    }

    public static List<String> findAllGroup1(Pattern pattern, String content) {
        return ReUtil.findAll(pattern, content, 1);
    }

    public static List<String> findAll(Pattern pattern, String content, int group) {
        return ReUtil.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int count(String regex, String content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.count(pattern, content);
    }

    public static int count(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, String content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static Integer getFirstNumber(String StringWithNumber) {
        return Convert.toInt(ReUtil.get(PatternPool.NUMBERS, StringWithNumber, 0), null);
    }

    public static boolean isMatch(String regex, String content) {
        if (content == null) {
            return false;
        }
        if (StrUtil.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtil.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, String content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(String content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(String content, Pattern pattern, String replacementTemplate) {
        if (StrUtil.isEmpty(content)) {
            return content;
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = ReUtil.findAll(PatternPool.GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, ReUtil.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(String content) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

