/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.exceptions.NotInitedException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class SyncFinisher {
    private CountDownLatch countDownLatch;
    private Set<Worker> workers = new LinkedHashSet<Worker>();

    public synchronized void addWorker(Worker worker) {
        this.workers.add(worker);
    }

    public void start() {
        this.countDownLatch = new CountDownLatch(this.workers.size());
        for (Worker worker : this.workers) {
            worker.start();
        }
    }

    public void await() throws InterruptedException {
        if (this.countDownLatch == null) {
            throw new NotInitedException("Please call start() method first!");
        }
        this.countDownLatch.await();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.countDownLatch.getCount();
    }

    public abstract class Worker
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.work();
            }
            finally {
                SyncFinisher.this.countDownLatch.countDown();
            }
        }

        public abstract void work();
    }
}

