/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.comparator.ComparatorException;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;

public class FieldComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 9157326766723846313L;
    private final Field field;

    public FieldComparator(Class<T> beanClass, String fieldName) {
        this.field = ClassUtil.getDeclaredField(beanClass, fieldName);
        if (this.field == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        try {
            v1 = (Comparable)this.field.get(o1);
            v2 = (Comparable)this.field.get(o2);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtil.compare(fieldValue1, fieldValue2);
        if (0 == result && ObjectUtil.notEqual(o1, o2)) {
            return 1;
        }
        return result;
    }
}

