/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.hikari;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.setting.Setting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class HikariDSFactory
extends DSFactory {
    public static final String DS_NAME = "HikariCP";
    private Map<String, HikariDataSource> dsMap = new ConcurrentHashMap<String, HikariDataSource>();

    public HikariDSFactory() {
        this(null);
    }

    public HikariDSFactory(Setting setting) {
        super(DS_NAME, HikariDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        HikariDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        HikariDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        HikariDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<HikariDataSource> values = this.dsMap.values();
            for (HikariDataSource ds : values) {
                IoUtil.close((Closeable)ds);
            }
            this.dsMap.clear();
        }
    }

    private HikariDataSource createDataSource(String group) {
        Properties config;
        if (group == null) {
            group = "";
        }
        if (CollectionUtil.isEmpty(config = this.setting.getProperties(group))) {
            throw new DbRuntimeException("No HikariCP config for group: [{}]", group);
        }
        boolean isShowSql = Convert.toBool(config.remove("showSql"), false);
        boolean isFormatSql = Convert.toBool(config.remove("formatSql"), false);
        boolean isShowParams = Convert.toBool(config.remove("showParams"), false);
        DbUtil.setShowSqlGlobal(isShowSql, isFormatSql, isShowParams);
        if (!config.containsKey("jdbcUrl") && config.containsKey("url")) {
            config.put("jdbcUrl", config.remove("url"));
        }
        if (!config.containsKey("username") && config.containsKey("user")) {
            config.put("username", config.remove("user"));
        }
        if (!config.containsKey("password") && config.containsKey("pass")) {
            config.put("password", config.remove("pass"));
        }
        if (!config.containsKey("driverClassName") && config.containsKey("driver")) {
            config.put("driverClassName", config.remove("driver"));
        }
        HikariDataSource ds = new HikariDataSource(new HikariConfig(config));
        return ds;
    }
}

