/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse>
implements Closeable {
    private HttpConnection httpConnection;
    private InputStream in;
    private volatile boolean isAsync;
    private int status;
    private boolean ignoreBody;

    protected HttpResponse(HttpConnection httpConnection, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.charset = charset;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.init();
    }

    public int getStatus() {
        return this.status;
    }

    public HttpResponse sync() throws HttpException {
        return this.isAsync ? this.forceSync() : this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookie() {
        String cookieStr = this.getCookieStr();
        if (StrUtil.isNotBlank(cookieStr)) {
            return HttpCookie.parse(cookieStr);
        }
        return null;
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        return new ByteArrayInputStream(this.bodyBytes);
    }

    public byte[] bodyBytes() {
        this.sync();
        return this.bodyBytes;
    }

    public String body() throws HttpException {
        try {
            return HttpUtil.getString(this.bodyBytes(), this.charset, null == this.charset);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeBody(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        try {
            long l = IoUtil.copyByNIO(this.in, out, 1024, streamProgress);
            return l;
        }
        finally {
            IoUtil.close(this);
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public long writeBody(File destFile, StreamProgress streamProgress) {
        if (null == destFile) {
            throw new NullPointerException("[destFile] is null!");
        }
        if (destFile.isDirectory()) {
            String path;
            String fileName = this.getFileNameFromDisposition();
            if (StrUtil.isBlank(fileName) && StrUtil.isBlank(fileName = StrUtil.subSuf(path = this.httpConnection.getUrl().getPath(), path.lastIndexOf(47) + 1))) {
                fileName = HttpUtil.encode(path, CharsetUtil.CHARSET_UTF_8);
            }
            destFile = FileUtil.file(destFile, fileName);
        }
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream(destFile);
            long path = this.writeBody(out, false, streamProgress);
            return path;
        }
        catch (IORuntimeException e) {
            throw new HttpException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public long writeBody(File destFile) {
        return this.writeBody(destFile, null);
    }

    public long writeBody(String destFilePath) {
        return this.writeBody(FileUtil.file(destFilePath));
    }

    @Override
    public void close() {
        IoUtil.close(this.in);
        this.httpConnection.disconnect();
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    private HttpResponse init() throws HttpException {
        block8: {
            try {
                this.status = this.httpConnection.responseCode();
                this.headers = this.httpConnection.headers();
                Charset charset = this.httpConnection.getCharset();
                if (null != charset) {
                    this.charset = charset;
                }
                this.in = this.status < 400 ? this.httpConnection.getInputStream() : this.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block8;
                throw new HttpException(e);
            }
        }
        if (null == this.in) {
            this.in = new ByteArrayInputStream(StrUtil.format((CharSequence)"Error request, response status: {}", this.status).getBytes());
        } else if (this.isGzip() && !(this.in instanceof GZIPInputStream)) {
            try {
                this.in = new GZIPInputStream(this.in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.isAsync ? this : this.forceSync();
    }

    private void readBody(InputStream in) throws IORuntimeException {
        FastByteArrayOutputStream out;
        block3: {
            if (this.ignoreBody) {
                return;
            }
            int contentLength = Convert.toInt(this.header(Header.CONTENT_LENGTH), 0);
            out = contentLength > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
            try {
                IoUtil.copy(in, out);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof EOFException || StrUtil.containsIgnoreCase(e.getMessage(), "Premature EOF")) break block3;
                throw e;
            }
        }
        this.bodyBytes = out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse forceSync() {
        block7: {
            try {
                this.readBody(this.in);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    break block7;
                }
                throw new HttpException(e);
            }
            finally {
                if (this.isAsync) {
                    this.isAsync = false;
                }
                this.close();
            }
        }
        return this;
    }

    private String getFileNameFromDisposition() {
        String fileName = null;
        String desposition = this.header(Header.CONTENT_DISPOSITION);
        if (StrUtil.isNotBlank(desposition) && StrUtil.isBlank(fileName = ReUtil.get("filename=\"(.*?)\"", desposition, 1))) {
            fileName = StrUtil.subAfter(desposition, "filename=", true);
        }
        return fileName;
    }
}

