/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.tools.maven;

import cn.home1.tools.maven.MavenSettingsSecurity;
import cn.home1.tools.maven.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenSettings {
    private final boolean debug;
    private final Settings settings;
    private final File settingsFile;
    private final MavenSettingsSecurity settingsSecurity;

    public MavenSettings(boolean debug, String settingsFilePathname, MavenSettingsSecurity settingsSecurity) throws IOException, XmlPullParserException {
        this.debug = debug;
        this.settingsFile = new File(settingsFilePathname);
        this.settingsSecurity = settingsSecurity;
        if (!this.settingsFile.exists()) {
            throw new IllegalArgumentException(String.format("Settings file : %s does not exist%n", this.settingsFile.getAbsolutePath()));
        }
        this.settings = MavenSettings.readSettings(this.settingsFile);
    }

    public String getText(String xpathExpression) {
        String nodeText = XmlUtils.xmlNodeText((File)this.settingsFile, (String)xpathExpression);
        if (this.debug) {
            System.err.printf("nodeText:%s%n", nodeText);
        }
        return this.nodeTextValue(nodeText);
    }

    public String nodeTextValue(String nodeText) {
        String result;
        Boolean envVar = nodeText != null && nodeText.startsWith("${env.") && nodeText.endsWith("}");
        if (this.debug) {
            System.err.printf("envVar: %s%n", envVar);
        }
        if (envVar.booleanValue()) {
            String envVarName = nodeText.substring(6, nodeText.length() - 1);
            if (this.debug) {
                System.err.printf("envVarName: %s%n", envVarName);
                Map<String, String> env = System.getenv();
                for (Map.Entry<String, String> entry : env.entrySet()) {
                    System.err.printf("env name: %s, value: *secret* %n", entry.getKey());
                }
            }
            result = System.getenv(envVarName);
        } else {
            result = this.settingsSecurity.decodeText(nodeText);
        }
        return result;
    }

    static Settings readSettings(File file) throws IOException, XmlPullParserException {
        return new SettingsXpp3Reader().read((InputStream)new FileInputStream(file));
    }
}

