/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.tools.maven;

import cn.home1.tools.maven.MavenSettings;
import cn.home1.tools.maven.MavenSettingsSecurity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class SettingsDecoder {
    private static final String SETTINGS_SECURITY_FILE_SHORT_OPT = "ss";
    private static final String SETTINGS_SECURITY_FILE_LONG_OPT = "settings-security";
    private static final String SETTINGS_FILE_LONG_OPT = "settings";
    private static final String SETTINGS_FILE_SHORT_OPT = "s";
    private static final String XPATH_SHORT_OPT = "x";
    private static final String XPATH_LONG_OPT = "xml-path";
    private static final String DEBUG_SHORT_OPT = "X";
    private static final String DEBUG_LONG_OPT = "debug";
    private static final int MISSING_OR_INVALID_ARGUMENTS_EXIT_CODE = 1;
    private MavenSettings settings;

    public SettingsDecoder(String settingsFileOpt, String securityFileOpt, boolean debug) throws Exception {
        MavenSettingsSecurity settingsSecurity = new MavenSettingsSecurity(SettingsDecoder.securityFilePathname(securityFileOpt), debug);
        if (debug) {
            System.err.printf("masterPassword:%s%n", settingsSecurity.getPlainTextMasterPassword());
        }
        this.settings = new MavenSettings(debug, SettingsDecoder.settingsFilePathname(settingsFileOpt), settingsSecurity);
    }

    public SettingsDecoder() throws Exception {
        this(null, null, false);
    }

    public String getText(String xpathOpt) {
        return this.settings.getText(xpathOpt);
    }

    public static void main(String ... args) throws Exception {
        boolean debug;
        Options options = SettingsDecoder.createOptions();
        CommandLine commandLine = new DefaultParser().parse(options, args);
        String settingsFileOpt = commandLine.getOptionValue(SETTINGS_FILE_SHORT_OPT);
        String securityFileOpt = commandLine.getOptionValue(SETTINGS_SECURITY_FILE_SHORT_OPT);
        String xpathOpt = commandLine.getOptionValue(XPATH_SHORT_OPT);
        boolean bl = debug = commandLine.getOptionValue(DEBUG_SHORT_OPT) != null;
        if (debug) {
            System.err.printf("xpathOpt:%s%n", xpathOpt);
        }
        try {
            String plainText = new SettingsDecoder(settingsFileOpt, securityFileOpt, debug).getText(xpathOpt);
            System.out.printf("%s", plainText);
        }
        catch (IllegalArgumentException ignored) {
            SettingsDecoder.printHelp(options);
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(SETTINGS_SECURITY_FILE_SHORT_OPT, SETTINGS_SECURITY_FILE_LONG_OPT, true, "location of settings-security.xml.");
        options.addOption(SETTINGS_FILE_SHORT_OPT, SETTINGS_FILE_LONG_OPT, true, "location of settings.xml file.");
        options.addOption(XPATH_SHORT_OPT, XPATH_LONG_OPT, true, "xml-path in settings.xml, only node text is supported.");
        options.addOption(DEBUG_SHORT_OPT, DEBUG_LONG_OPT, true, "produce execution debug output.");
        return options;
    }

    private static String pathname(String optionName, String optionValue, String filename) {
        String pathname;
        if (optionValue == null) {
            String envMavenSettings = SettingsDecoder.systemEnvMavenSettings();
            if (envMavenSettings != null && envMavenSettings.contains("-" + optionName + " ")) {
                Matcher matcher = Pattern.compile("-" + optionName + "[ ]+([^\\s]+)").matcher(envMavenSettings);
                matcher.find();
                pathname = matcher.group(1).replace("${HOME}", SettingsDecoder.systemUserHome());
            } else {
                pathname = SettingsDecoder.systemUserHome() + "/.m2/" + filename;
            }
        } else {
            pathname = optionValue;
        }
        return pathname;
    }

    private static void printHelp(Options options) {
        new HelpFormatter().printHelp("maven-settings-decoder", options);
    }

    private static String settingsFilePathname(String settingsFileOpt) {
        return SettingsDecoder.pathname(SETTINGS_FILE_SHORT_OPT, settingsFileOpt, "settings.xml");
    }

    private static String securityFilePathname(String securityFileOpt) {
        return SettingsDecoder.pathname(SETTINGS_SECURITY_FILE_SHORT_OPT, securityFileOpt, "settings-security.xml");
    }

    private static String systemEnvMavenSettings() {
        return System.getenv("MAVEN_SETTINGS");
    }

    private static String systemUserHome() {
        return System.getProperty("user.home");
    }
}

