/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.tools.maven;

import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public final class PlexusCipherUtils {
    private PlexusCipherUtils() {
    }

    public static String decodeMasterPassword(String encodedMasterPassword, boolean debug) throws PlexusCipherException {
        String key = "settings.security";
        return PlexusCipherUtils.decodeText(encodedMasterPassword, "settings.security", debug);
    }

    public static String encodeText(String str, String passPhrase) throws PlexusCipherException {
        return PlexusCipherUtils.encodeText(str, passPhrase, false);
    }

    public static String encodeText(String str, String passPhrase, boolean debug) throws PlexusCipherException {
        String result;
        if (passPhrase != null) {
            if (debug) {
                System.err.printf("key not null%n", new Object[0]);
            }
            if (debug) {
                System.err.printf("str: %s%n", str);
            }
            result = new DefaultPlexusCipher().encryptAndDecorate(str, passPhrase);
        } else {
            if (debug) {
                System.err.printf("key is null%n", new Object[0]);
            }
            result = str;
        }
        return result;
    }

    public static String decodeText(String str, String passPhrase) throws PlexusCipherException {
        return PlexusCipherUtils.decodeText(str, passPhrase, false);
    }

    public static String decodeText(String str, String passPhrase, boolean debug) throws PlexusCipherException {
        String result;
        if (passPhrase != null) {
            if (debug) {
                System.err.printf("key not null%n", new Object[0]);
            }
            Boolean encoded = str != null && str.startsWith("{") && str.endsWith("}");
            if (debug) {
                System.err.printf("encoded: %s%n", encoded);
            }
            result = encoded.booleanValue() ? new DefaultPlexusCipher().decryptDecorated(str, passPhrase) : str;
        } else {
            if (debug) {
                System.err.printf("key is null%n", new Object[0]);
            }
            result = str;
        }
        return result;
    }
}

