/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.tools.maven;

import cn.home1.tools.maven.PlexusCipherUtils;
import cn.home1.tools.maven.XmlUtils;
import java.io.File;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class MavenSettingsSecurity {
    private final boolean debug;
    private final String plainTextMasterPassword;

    public MavenSettingsSecurity(boolean debug, String encodedMasterPassword) {
        this.debug = debug;
        try {
            this.plainTextMasterPassword = PlexusCipherUtils.decodeMasterPassword(encodedMasterPassword, debug);
        }
        catch (PlexusCipherException ex) {
            throw new IllegalArgumentException(encodedMasterPassword, ex);
        }
    }

    public MavenSettingsSecurity(String securityFilePathname, boolean debug) {
        this(debug, MavenSettingsSecurity.encodedMasterPassword(securityFilePathname));
    }

    public String decodeText(String text) {
        try {
            return PlexusCipherUtils.decodeText(text, this.plainTextMasterPassword, this.debug);
        }
        catch (PlexusCipherException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String encodeText(String text) {
        try {
            return PlexusCipherUtils.encodeText(text, this.plainTextMasterPassword, this.debug);
        }
        catch (PlexusCipherException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getPlainTextMasterPassword() {
        return this.plainTextMasterPassword;
    }

    public static String encodedMasterPassword(String securityFilePathname) {
        File securityFile = new File(securityFilePathname);
        String result = !securityFile.exists() ? null : MavenSettingsSecurity.encodedMasterPassword(securityFile);
        return result;
    }

    static String encodedMasterPassword(File file) {
        return XmlUtils.xmlNodeText(file, "/settingsSecurity/master/text()");
    }
}

