/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.oss.lib.swagger.starter;

import cn.home1.oss.boot.autoconfigure.PathUtils;
import cn.home1.oss.lib.swagger.SwaggerUtils;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Type;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@ConditionalOnClass(value={ManagementServerProperties.class})
@Configuration
public class ManagementConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ManagementConfiguration.class);
    public static final String DOCKET_MANAGEMENT = "docketManagement";
    @Autowired(required=false)
    private ManagementServerProperties managementServerProperties;

    @ConditionalOnMissingBean(name={"docketManagement"})
    @Bean(name={"docketManagement"})
    public Docket docketManagement() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(SwaggerUtils.apiInfo("spring-boot-starter-actuator", "spring boot's management endpoints")).groupName("management endpoints").select().apis(Predicates.or((Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.boot.actuate"), (Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.cloud.context"))).paths(this.managementPaths()).build();
        Optional<ResolvedType> modelResolvedError = ManagementConfiguration.modelResolvedError();
        return modelResolvedError.isPresent() ? docket.additionalModels(modelResolvedError.get(), new ResolvedType[0]) : docket;
    }

    @Bean(name={"MANAGEMENT_PATHS"})
    public Predicate<String> managementPaths() {
        String managementContextPath = this.managementServerProperties != null ? this.managementServerProperties.getContextPath() : "";
        return input -> PathUtils.managementPaths((String)managementContextPath).test(input);
    }

    static Optional<ResolvedType> modelResolvedError() {
        Optional<ResolvedType> result;
        try {
            result = Optional.ofNullable(new TypeResolver().resolve(Class.forName("cn.home1.oss.lib.errorhandle.api.ResolvedError"), new Type[0]));
        }
        catch (ClassNotFoundException ex) {
            log.trace("Swagger can't find class cn.home1.oss.lib.errorhandle.api.ResolvedError,so api will not show this info in swagger api document.", (Throwable)ex);
            result = Optional.empty();
        }
        return result;
    }
}

