/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.oss.lib.swagger.starter;

import cn.home1.oss.boot.autoconfigure.AppUtils;
import cn.home1.oss.boot.autoconfigure.ConditionalOnNotEnvProduction;
import cn.home1.oss.lib.swagger.SwaggerUtils;
import cn.home1.oss.lib.swagger.starter.ManagementConfiguration;
import cn.home1.oss.lib.swagger.starter.NoManagementConfiguration;
import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.SpringfoxWebMvcConfiguration;
import springfox.documentation.spring.web.json.JacksonModuleRegistrar;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.configuration.SwaggerCommonConfiguration;
import springfox.documentation.swagger2.configuration.Swagger2JacksonModule;

@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
@ConditionalOnNotEnvProduction
@ConditionalOnWebApplication
@Configuration
@Import(value={SpringfoxWebMvcConfiguration.class, SwaggerCommonConfiguration.class, ManagementConfiguration.class, NoManagementConfiguration.class})
@ComponentScan(basePackages={"springfox.documentation.swagger2.readers.parameter", "springfox.documentation.swagger2.web", "springfox.documentation.swagger2.mappers"})
public class Swagger2DocumentationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Swagger2DocumentationAutoConfiguration.class);
    public static final String DOCKET_APPLICATION = "docketApplication";
    @Autowired(required=false)
    private ServerProperties serverProperties;
    @Qualifier(value="MANAGEMENT_PATHS")
    @Autowired
    public Predicate<String> managementPaths;

    @Bean
    public JacksonModuleRegistrar swagger2Module() {
        return new Swagger2JacksonModule();
    }

    @ConditionalOnMissingBean(name={"docketApplication"})
    @Bean(name={"docketApplication"})
    public Docket docketApplication() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(SwaggerUtils.apiInfo("application", "application's endpoints")).groupName("api").select().apis(Predicates.or(this.applicationAips(), this.springApis())).paths(Predicates.not(this.managementPaths)).build();
        Optional<ResolvedType> modelResolvedError = ManagementConfiguration.modelResolvedError();
        return modelResolvedError.isPresent() ? docket.additionalModels(modelResolvedError.get(), new ResolvedType[0]) : docket;
    }

    private Predicate<String> errorPath() {
        return PathSelectors.ant((String)this.serverProperties.getError().getPath());
    }

    private Predicate<String> anyPath() {
        return PathSelectors.regex((String)"/.*");
    }

    private Predicate<RequestHandler> applicationAips() {
        Predicate ossLibApi = RequestHandlerSelectors.basePackage((String)"cn.home1");
        String applicationPackage = AppUtils.appBasePackage((String)"");
        return StringUtils.isNotBlank((CharSequence)applicationPackage) ? Predicates.or((Predicate)RequestHandlerSelectors.basePackage((String)applicationPackage), (Predicate)ossLibApi) : RequestHandlerSelectors.any();
    }

    private Predicate<RequestHandler> springApis() {
        return RequestHandlerSelectors.basePackage((String)"org.springframework");
    }

    @Configuration
    @ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={ObjectPostProcessor.class})
    @ConditionalOnProperty(prefix="security.basic", name={"enabled"}, matchIfMissing=true)
    static class SwaggerSecurityConfiguration {
        SwaggerSecurityConfiguration() {
        }

        @Bean
        public WebSecurityConfigurerAdapter swaggerSecurityConfigurer() {
            return new SwaggerSecurityConfigurer();
        }

        @Order(value=0x7FFFFFEF)
        private static class SwaggerSecurityConfigurer
        extends WebSecurityConfigurerAdapter {
            @Autowired
            private Environment environment;

            private SwaggerSecurityConfigurer() {
            }

            public void init(WebSecurity web) throws Exception {
                RequestMatcher requestMatcher = this.swaggerRequestMatcher();
                if (requestMatcher != null) {
                    web.ignoring().requestMatchers(new RequestMatcher[]{requestMatcher});
                }
            }

            private RequestMatcher swaggerRequestMatcher() {
                OrRequestMatcher requestMatcher;
                LinkedHashSet paths = Sets.newLinkedHashSet();
                paths.add("/webjars/**");
                paths.add(this.environment.getProperty("springfox.documentation.swagger.v1.path", "/v1/**"));
                paths.add(this.environment.getProperty("springfox.documentation.swagger.v2.path", "/v2/**"));
                paths.addAll(Lists.newArrayList((Object[])new String[]{"/swagger-ui.html", "/swagger-resources/**"}));
                if (!paths.isEmpty()) {
                    List matchers = paths.stream().map(pattern -> new AntPathRequestMatcher(pattern, null)).collect(Collectors.toList());
                    requestMatcher = new OrRequestMatcher(matchers);
                } else {
                    requestMatcher = null;
                }
                return requestMatcher;
            }
        }
    }
}

