/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.methodcanary.lib;

import cn.hikyson.methodcanary.lib.MethodCanaryTaskDispatcher;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class MethodCanaryTaskQueue {
    private BlockingQueue<Runnable> mTaskQueue = new LinkedBlockingQueue<Runnable>();
    private MethodCanaryTaskDispatcher mDispatcher;
    private String mName;

    MethodCanaryTaskQueue(String name) {
        this.mName = name;
    }

    void queueTask(Runnable runnable) {
        this.mTaskQueue.offer(runnable);
    }

    Runnable takeNextTask() throws InterruptedException {
        return this.mTaskQueue.take();
    }

    boolean isEmpty() {
        return this.mTaskQueue.isEmpty();
    }

    synchronized void start() {
        if (this.mDispatcher == null) {
            this.mDispatcher = new MethodCanaryTaskDispatcher(this);
            this.mDispatcher.setName(this.mName);
            this.mDispatcher.start();
        }
    }

    synchronized void stop() {
        if (this.mDispatcher != null) {
            this.mDispatcher.quit();
            this.mDispatcher = null;
        }
    }
}

