/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.methodcanary.lib;

import cn.hikyson.methodcanary.lib.MethodCanaryConfig;
import cn.hikyson.methodcanary.lib.MethodCanaryTaskQueue;
import cn.hikyson.methodcanary.lib.MethodEvent;
import cn.hikyson.methodcanary.lib.ThreadInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class MethodCanaryMethodRecord {
    private volatile boolean mIsRecording = false;
    private Map<ThreadInfo, List<MethodEvent>> mMethodEventMap = new HashMap<ThreadInfo, List<MethodEvent>>();
    private Map<ThreadInfo, Stack<MethodEvent>> mMethodEventStackMap = new HashMap<ThreadInfo, Stack<MethodEvent>>();
    private MethodCanaryTaskQueue mTaskQueue;
    private ThreadInfo mThreadInfoInstance = new ThreadInfo();

    MethodCanaryMethodRecord(MethodCanaryTaskQueue taskQueue) {
        this.mTaskQueue = taskQueue;
    }

    void startRecordRightNow() {
        this.mIsRecording = true;
    }

    void stopRecordRightNow() {
        this.mIsRecording = false;
    }

    void getRecords(final long startTimeMillis, final long stopTimeMillis, final MethodCanaryConfig methodCanaryConfig, final OnGetRecordsCallback onGetRecordsCallback) {
        this.mTaskQueue.queueTask(new Runnable(){

            @Override
            public void run() {
                HashMap<ThreadInfo, List<MethodEvent>> filtered = new HashMap<ThreadInfo, List<MethodEvent>>();
                for (Map.Entry entry : MethodCanaryMethodRecord.this.mMethodEventMap.entrySet()) {
                    ArrayList<MethodEvent> filteredMethodEventsThread = new ArrayList<MethodEvent>();
                    for (MethodEvent methodEvent : (List)entry.getValue()) {
                        long methodCost;
                        if (methodEvent.eventTimeMillis < startTimeMillis || methodEvent.eventTimeMillis > stopTimeMillis || (methodCost = MethodCanaryMethodRecord.this.getMethodEventCost(methodEvent)) >= 0L && methodCost <= methodCanaryConfig.lowCostThresholdTimeMillis) continue;
                        filteredMethodEventsThread.add(methodEvent);
                    }
                    if (filteredMethodEventsThread.isEmpty()) continue;
                    filtered.put((ThreadInfo)entry.getKey(), (List<MethodEvent>)filteredMethodEventsThread);
                }
                if (onGetRecordsCallback != null) {
                    onGetRecordsCallback.onGetRecords(filtered);
                }
            }
        });
    }

    private long getMethodEventCost(MethodEvent methodEvent) {
        if (methodEvent.isEnter) {
            if (methodEvent.pairMethodEvent != null) {
                return methodEvent.pairMethodEvent.eventTimeMillis - methodEvent.eventTimeMillis;
            }
        } else if (methodEvent.pairMethodEvent != null) {
            return methodEvent.eventTimeMillis - methodEvent.pairMethodEvent.eventTimeMillis;
        }
        return -1L;
    }

    void onMethodEnter(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        if (this.mIsRecording) {
            this.onMethodEventPostProcess(new MethodEvent(className, accessFlag, methodName, desc, true, System.currentTimeMillis(), type));
        }
    }

    void onMethodExit(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        if (this.mIsRecording) {
            this.onMethodEventPostProcess(new MethodEvent(className, accessFlag, methodName, desc, false, System.currentTimeMillis(), type));
        }
    }

    private void onMethodEventPostProcess(final MethodEvent methodEvent) {
        Thread currentThread = Thread.currentThread();
        final long id = currentThread.getId();
        final String name = currentThread.getName();
        final int priority = currentThread.getPriority();
        this.mTaskQueue.queueTask(new Runnable(){

            @Override
            public void run() {
                Stack<MethodEvent> methodEventStack;
                ThreadInfo threadInfo = MethodCanaryMethodRecord.this.obtainThreadInfo(id, name, priority);
                ArrayList<MethodEvent> methodEvents = (ArrayList<MethodEvent>)MethodCanaryMethodRecord.this.mMethodEventMap.get(threadInfo);
                ThreadInfo copy = null;
                if (methodEvents == null) {
                    methodEvents = new ArrayList<MethodEvent>(128);
                    copy = threadInfo.copy();
                    MethodCanaryMethodRecord.this.mMethodEventMap.put(copy, methodEvents);
                }
                if ((methodEventStack = (Stack<MethodEvent>)MethodCanaryMethodRecord.this.mMethodEventStackMap.get(threadInfo)) == null) {
                    methodEventStack = new Stack<MethodEvent>();
                    MethodCanaryMethodRecord.this.mMethodEventStackMap.put(copy == null ? threadInfo.copy() : copy, methodEventStack);
                }
                methodEvents.add(methodEvent);
                if (methodEvent.isEnter) {
                    methodEventStack.push(methodEvent);
                } else {
                    MethodEvent lastMethodEnterEvent = null;
                    if (!methodEventStack.empty()) {
                        lastMethodEnterEvent = (MethodEvent)methodEventStack.pop();
                    }
                    if (lastMethodEnterEvent != null) {
                        lastMethodEnterEvent.pairMethodEvent = methodEvent;
                        methodEvent.pairMethodEvent = lastMethodEnterEvent;
                    }
                }
            }
        });
    }

    private ThreadInfo obtainThreadInfo(long id, String name, int priority) {
        this.mThreadInfoInstance.id = id;
        this.mThreadInfoInstance.name = name;
        this.mThreadInfoInstance.priority = priority;
        return this.mThreadInfoInstance;
    }

    static interface OnGetRecordsCallback {
        public void onGetRecords(Map<ThreadInfo, List<MethodEvent>> var1);
    }
}

