/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.methodcanary.lib;

import android.os.Looper;
import cn.hikyson.methodcanary.lib.MethodCanaryLogger;
import cn.hikyson.methodcanary.lib.MethodEvent;
import cn.hikyson.methodcanary.lib.OnPageLifecycleEventCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

class MethodCanaryForSpecial {
    private Stack<MethodEvent> mMethodEventStackMap = new Stack();
    private final Object mLockForOnPageLifecycleEventCallback = new Object();
    private List<OnPageLifecycleEventCallback> mOnPageLifecycleEventCallbacks = new ArrayList<OnPageLifecycleEventCallback>();

    MethodCanaryForSpecial() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOnPageLifecycleEventCallback(OnPageLifecycleEventCallback onPageLifecycleEventCallback) {
        Object object = this.mLockForOnPageLifecycleEventCallback;
        synchronized (object) {
            this.mOnPageLifecycleEventCallbacks.add(onPageLifecycleEventCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOnPageLifecycleEventCallback(OnPageLifecycleEventCallback onPageLifecycleEventCallback) {
        Object object = this.mLockForOnPageLifecycleEventCallback;
        synchronized (object) {
            this.mOnPageLifecycleEventCallbacks.remove(onPageLifecycleEventCallback);
        }
    }

    void onMethodEnter(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        if (!this.filterMethod(accessFlag, className, methodName, desc, type, objs)) {
            return;
        }
        MethodEvent methodEnterEvent = new MethodEvent(className, accessFlag, methodName, desc, true, System.currentTimeMillis(), type);
        this.mMethodEventStackMap.push(methodEnterEvent);
        MethodCanaryLogger.log(String.format("MethodCanary page [%s] lifecycle event [%s] start.", className, methodName));
        this.notifyOnPageLifecycleEventCallbacks(methodEnterEvent, objs[0]);
    }

    void onMethodExit(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        MethodEvent methodEnterEvent;
        if (!this.filterMethod(accessFlag, className, methodName, desc, type, objs)) {
            return;
        }
        MethodEvent methodExitEvent = new MethodEvent(className, accessFlag, methodName, desc, false, System.currentTimeMillis(), type);
        if (!this.mMethodEventStackMap.isEmpty() && (methodEnterEvent = this.mMethodEventStackMap.pop()) != null) {
            methodExitEvent.pairMethodEvent = methodEnterEvent;
            methodEnterEvent.pairMethodEvent = methodExitEvent;
        }
        MethodCanaryLogger.log(String.format("MethodCanary page [%s] lifecycle event [%s] end, cost %sms", className, methodName, methodExitEvent.pairMethodEvent == null ? 0L : methodExitEvent.eventTimeMillis - methodExitEvent.pairMethodEvent.eventTimeMillis));
        this.notifyOnPageLifecycleEventCallbacks(methodExitEvent, objs[0]);
    }

    private boolean filterMethod(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            MethodCanaryLogger.log(String.format("MethodCanary ignored! [%s].[%s] is lifecycle event and must run in main thread.", className, methodName));
            return false;
        }
        if (!this.checkLifecycleOwnerIsSelf(className, objs[0])) {
            MethodCanaryLogger.log(String.format("MethodCanary ignored! class [%s] and real page [%s] are not match.", className, objs[0] == null ? "null" : objs[0].getClass().getName()));
            return false;
        }
        return true;
    }

    private boolean checkLifecycleOwnerIsSelf(String className, Object page) {
        if (page == null) {
            return false;
        }
        return page.getClass().getName().equals(className.replaceAll("/", "."));
    }

    private void notifyOnPageLifecycleEventCallbacks(MethodEvent lifecycleMethodEvent, Object page) {
        if (this.mOnPageLifecycleEventCallbacks == null || this.mOnPageLifecycleEventCallbacks.isEmpty()) {
            return;
        }
        Object[] listeners = this.mOnPageLifecycleEventCallbacks.toArray();
        if (listeners != null) {
            for (Object o : listeners) {
                ((OnPageLifecycleEventCallback)o).onLifecycleEvent(lifecycleMethodEvent, page);
            }
        }
    }
}

