/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operatelog.autoconfigure.configuration;

import cn.hangsman.operatelog.autoconfigure.annotation.EnableOperateLog;
import cn.hangsman.operatelog.core.annotation.OperateLog;
import cn.hangsman.operatelog.core.interceptor.OperateLogInterceptor;
import cn.hangsman.operatelog.core.logger.DefaultOperateLogLogger;
import cn.hangsman.operatelog.core.logger.OperateLogLogger;
import cn.hangsman.operatelog.core.service.DefaultOperateLogRecorder;
import cn.hangsman.operatelog.core.service.DefaultOperatorServiceImpl;
import cn.hangsman.operatelog.core.service.OperateLogRecorder;
import cn.hangsman.operatelog.core.service.OperatorService;
import cn.hangsman.operatelog.core.spel.SpelFunction;
import cn.hangsman.operatelog.core.spel.SpelFunctionExpressionParser;
import cn.hangsman.operatelog.core.spel.SpelFunctionFactory;
import cn.hangsman.operatelog.core.spel.TemplateExpressionEvaluator;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class OperateLogProxyAutoConfiguration
implements ImportAware {
    private String tenant;

    @Bean
    public DefaultBeanFactoryPointcutAdvisor advisor(OperatorService operatorService, OperateLogLogger logger, SpelFunctionExpressionParser expressionParser) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)new AnnotationMatchingPointcut(null, OperateLog.class));
        OperateLogInterceptor interceptor = new OperateLogInterceptor(this.tenant, logger);
        TemplateExpressionEvaluator expressionEvaluator = new TemplateExpressionEvaluator(expressionParser);
        interceptor.setExpressionEvaluator(expressionEvaluator);
        interceptor.setOperatorService(operatorService);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpelFunctionFactory.class})
    public SpelFunctionFactory spelFunctionFactory(@Autowired(required=false) List<SpelFunction> parseFunctions) {
        return new SpelFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpelFunctionExpressionParser.class})
    public SpelFunctionExpressionParser operateLogTemplateParser(SpelFunctionFactory functionFactory) {
        return new SpelFunctionExpressionParser(functionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={OperateLogLogger.class})
    public OperateLogLogger defaultOperateLogLogger(OperateLogRecorder recordService) {
        return new DefaultOperateLogLogger(recordService);
    }

    @Bean
    @ConditionalOnMissingBean(value={OperatorService.class})
    public OperatorService defaultOperatorService() {
        return new DefaultOperatorServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={OperateLogRecorder.class})
    public OperateLogRecorder defaultOperateLogRecorder() {
        return new DefaultOperateLogRecorder();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String annotationName = EnableOperateLog.class.getName();
        Map annotationAttributes = importMetadata.getAnnotationAttributes(annotationName);
        assert (annotationAttributes != null);
        this.tenant = annotationAttributes.get("tenant").toString();
    }
}

