package cn.hangsman.operatelog.autoconfigure.configuration;

import cn.hangsman.operatelog.autoconfigure.annotation.EnableOperateLog;
import cn.hangsman.operatelog.core.annotation.OperateLog;
import cn.hangsman.operatelog.core.interceptor.OperateLogInterceptor;
import cn.hangsman.operatelog.core.logger.DefaultOperateLogLogger;
import cn.hangsman.operatelog.core.logger.OperateLogLogger;
import cn.hangsman.operatelog.core.service.DefaultOperateLogRecorder;
import cn.hangsman.operatelog.core.service.DefaultOperatorServiceImpl;
import cn.hangsman.operatelog.core.service.OperateLogRecorder;
import cn.hangsman.operatelog.core.service.OperatorService;
import cn.hangsman.operatelog.core.spel.SpelFunction;
import cn.hangsman.operatelog.core.spel.SpelFunctionExpressionParser;
import cn.hangsman.operatelog.core.spel.SpelFunctionFactory;
import cn.hangsman.operatelog.core.spel.TemplateExpressionEvaluator;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;

import java.util.List;
import java.util.Map;

/**
 * Created by 2022/1/11 13:30
 *
 * @author hangsman
 * @since 1.0
 */
@Configuration
public class OperateLogProxyAutoConfiguration implements ImportAware {

    private String tenant;

    @Bean
    public DefaultBeanFactoryPointcutAdvisor advisor(OperatorService operatorService, OperateLogLogger logger, SpelFunctionExpressionParser expressionParser) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut(new AnnotationMatchingPointcut(null, OperateLog.class));
        OperateLogInterceptor interceptor = new OperateLogInterceptor(tenant, logger);
        TemplateExpressionEvaluator expressionEvaluator = new TemplateExpressionEvaluator(expressionParser);
        interceptor.setExpressionEvaluator(expressionEvaluator);
        interceptor.setOperatorService(operatorService);
        advisor.setAdvice(interceptor);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean(SpelFunctionFactory.class)
    public SpelFunctionFactory spelFunctionFactory(@Autowired(required = false) List<SpelFunction> parseFunctions) {
        return new SpelFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(SpelFunctionExpressionParser.class)
    public SpelFunctionExpressionParser operateLogTemplateParser(SpelFunctionFactory functionFactory) {
        return new SpelFunctionExpressionParser(functionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(OperateLogLogger.class)
    public OperateLogLogger defaultOperateLogLogger(OperateLogRecorder recordService) {
        return new DefaultOperateLogLogger(recordService);
    }

    @Bean
    @ConditionalOnMissingBean(OperatorService.class)
    public OperatorService defaultOperatorService() {
        return new DefaultOperatorServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(OperateLogRecorder.class)
    public OperateLogRecorder defaultOperateLogRecorder() {
        return new DefaultOperateLogRecorder();
    }

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String annotationName = EnableOperateLog.class.getName();
        Map<String, Object> annotationAttributes = importMetadata.getAnnotationAttributes(annotationName);
        assert annotationAttributes != null;
        this.tenant = annotationAttributes.get("tenant").toString();
    }
}
