/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operatelog.autoconfigure.configuration;

import cn.hangsman.operatelog.autoconfigure.annotation.EnableOperateLog;
import cn.hangsman.operatelog.core.OperateLogLogger;
import cn.hangsman.operatelog.core.annotation.OperateLog;
import cn.hangsman.operatelog.core.function.LogParseFunction;
import cn.hangsman.operatelog.core.function.LogParseFunctionFactory;
import cn.hangsman.operatelog.core.interceptor.OperateLogInterceptor;
import cn.hangsman.operatelog.core.interceptor.OperateLogTemplateParser;
import cn.hangsman.operatelog.core.service.DefaultOperateLogRecordServiceImpl;
import cn.hangsman.operatelog.core.service.DefaultOperatorServiceImpl;
import cn.hangsman.operatelog.core.service.OperateLogRecordService;
import cn.hangsman.operatelog.core.service.OperatorService;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class OperateLogProxyAutoConfiguration
implements ImportAware {
    private String tenant;

    @Bean
    @Role(value=2)
    public DefaultBeanFactoryPointcutAdvisor advisor(OperatorService operatorService, OperateLogLogger logger) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)new AnnotationMatchingPointcut(null, OperateLog.class));
        OperateLogInterceptor interceptor = new OperateLogInterceptor(operatorService, logger);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean(value={LogParseFunctionFactory.class})
    public LogParseFunctionFactory parseFunctionFactory(@Autowired(required=false) List<LogParseFunction> parseFunctions) {
        return new LogParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(value={OperateLogTemplateParser.class})
    public OperateLogTemplateParser operateLogTemplateParser(LogParseFunctionFactory parseFunctionFactory) {
        return new OperateLogTemplateParser(parseFunctionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={OperateLogLogger.class})
    public OperateLogLogger defaultOperateLogLogger(OperateLogTemplateParser templateParser, OperateLogRecordService recordService) {
        return new OperateLogLogger(this.tenant, templateParser, recordService);
    }

    @Bean
    @ConditionalOnMissingBean(value={OperatorService.class})
    public OperatorService defaultOperatorService() {
        return new DefaultOperatorServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={OperateLogRecordService.class})
    public OperateLogRecordService defaultOperateLogRecordService() {
        return new DefaultOperateLogRecordServiceImpl();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String annotationName = EnableOperateLog.class.getName();
        Map annotationAttributes = importMetadata.getAnnotationAttributes(annotationName);
        assert (annotationAttributes != null);
        this.tenant = annotationAttributes.get("tenant").toString();
    }
}

