package cn.hangsman.operatelog.autoconfigure.configuration;

import cn.hangsman.operatelog.autoconfigure.annotation.EnableOperateLog;
import cn.hangsman.operatelog.core.OperateLogLogger;
import cn.hangsman.operatelog.core.annotation.OperateLog;
import cn.hangsman.operatelog.core.function.LogParseFunction;
import cn.hangsman.operatelog.core.function.LogParseFunctionFactory;
import cn.hangsman.operatelog.core.interceptor.OperateLogInterceptor;
import cn.hangsman.operatelog.core.interceptor.OperateLogTemplateParser;
import cn.hangsman.operatelog.core.service.DefaultOperateLogRecordServiceImpl;
import cn.hangsman.operatelog.core.service.DefaultOperatorServiceImpl;
import cn.hangsman.operatelog.core.service.OperateLogRecordService;
import cn.hangsman.operatelog.core.service.OperatorService;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;

import java.util.List;
import java.util.Map;

/**
 * Created by 2022/1/11 13:30
 *
 * @author hangsman
 * @since 1.0
 */
@Configuration
public class OperateLogProxyAutoConfiguration implements ImportAware {

    private String tenant;

    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public DefaultBeanFactoryPointcutAdvisor advisor(OperatorService operatorService, OperateLogLogger logger) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut(new AnnotationMatchingPointcut(null, OperateLog.class));
        OperateLogInterceptor interceptor = new OperateLogInterceptor(operatorService, logger);
        advisor.setAdvice(interceptor);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean(LogParseFunctionFactory.class)
    public LogParseFunctionFactory parseFunctionFactory(@Autowired(required = false) List<LogParseFunction> parseFunctions) {
        return new LogParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(OperateLogTemplateParser.class)
    public OperateLogTemplateParser operateLogTemplateParser(LogParseFunctionFactory parseFunctionFactory) {
        return new OperateLogTemplateParser(parseFunctionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(OperateLogLogger.class)
    public OperateLogLogger defaultOperateLogLogger(OperateLogTemplateParser templateParser, OperateLogRecordService recordService) {
        return new OperateLogLogger(tenant, templateParser, recordService);
    }

    @Bean
    @ConditionalOnMissingBean(OperatorService.class)
    public OperatorService defaultOperatorService() {
        return new DefaultOperatorServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(OperateLogRecordService.class)
    public OperateLogRecordService defaultOperateLogRecordService() {
        return new DefaultOperateLogRecordServiceImpl();
    }

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String annotationName = EnableOperateLog.class.getName();
        Map<String, Object> annotationAttributes = importMetadata.getAnnotationAttributes(annotationName);
        assert annotationAttributes != null;
        this.tenant = annotationAttributes.get("tenant").toString();
    }
}
