package cn.hangsman.operatelog.autoconfigure;

import cn.hangsman.operatelog.autoconfigure.annotation.EnableOperateLog;
import cn.hangsman.operatelog.autoconfigure.configuration.OperateLogProxyAutoConfiguration;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;

/**
 * Created by 2022/1/11 15:38
 *
 * @author hangsman
 * @since 1.0
 */
public class OperateLogImportSelector extends AdviceModeImportSelector<EnableOperateLog> {

    @Override
    protected String[] selectImports(AdviceMode adviceMode) {
        switch (adviceMode) {
            case PROXY:
                return new String[]{OperateLogProxyAutoConfiguration.class.getName()};
            case ASPECTJ:
                return new String[]{"cn.hangsman.operatelog.autoconfigure.configuration.OperateLogProxyAutoConfiguration"};
            default:
                return null;
        }
    }
}
