/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.RuntimeContext;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.ref.ConnectionContextImpl;
import sqlj.runtime.ref.ProfileGroup;
import sqlj.runtime.util.SqljTrace;

public class DefaultContext
extends ConnectionContextImpl
implements ConnectionContext {
    private static final String m_T2zos_SQLJ_Runtime = "__T2Zos_SQLJRuntime";
    private static final ProfileGroup m_profiles = new ProfileGroup();
    private static ThreadLocal m_threadLocalContext = null;
    private static DefaultContext m_defaultContext = null;

    public static void enableThreadLocalStorage() {
        if (m_threadLocalContext == null) {
            m_threadLocalContext = new ThreadLocal();
        }
    }

    public static void freeProfileCache() {
        m_profiles.freeContextProfileCache();
        ProfileGroup.freeGlobalProfileCache();
    }

    public static void enableGlobalProfileCache() {
        ProfileGroup.enableGlobalProfileCache();
    }

    public static void disableGlobalProfileCache() {
        ProfileGroup.disableGlobalProfileCache();
    }

    public ProfileGroup getProfileGroup() {
        return m_profiles;
    }

    public void setT2ZosCachedDefaultCtxForDriverUseOnly(boolean bl2, String string) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.setT2ZosCachedDefaultCtxForDriverUseOnly() called for this context " + this + " calledFrom: " + string);
        }
        if (string != null && string.equals(m_T2zos_SQLJ_Runtime)) {
            this.m_isT2ZosCachedDefaultContext = bl2;
        }
    }

    public static Object getProfileKey(Loader loader, String string) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getProfileKey() for profile " + string + " is called");
        }
        return m_profiles.getProfileKey(loader, string);
    }

    public static Profile getProfile(Object object) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getProfile() for key " + ((ProfileGroup.Key)object).index + " is called");
        }
        return m_profiles.getProfile(object);
    }

    public static DefaultContext getDefaultContext() {
        Connection connection = null;
        DefaultContext defaultContext = null;
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getDefaultContext() is entry : " + m_defaultContext);
        }
        if (m_threadLocalContext != null && (defaultContext = (DefaultContext)m_threadLocalContext.get()) != null) {
            return defaultContext;
        }
        if (m_defaultContext == null && (connection = RuntimeContext.getRuntime().getDefaultConnection()) != null) {
            try {
                m_defaultContext = new DefaultContext(connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getDefaultContext() is exit : " + m_defaultContext);
            SqljTrace.printMessage("DefaultContext connection : " + m_defaultContext.getConnection());
        }
        return m_defaultContext;
    }

    public static void setDefaultContext(DefaultContext defaultContext) {
        if (m_threadLocalContext != null) {
            m_threadLocalContext.set(defaultContext);
        }
        m_defaultContext = defaultContext;
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.setDefaultContext() exit : " + m_defaultContext);
            SqljTrace.printMessage("DefaultContext connection : " + m_defaultContext.getConnection());
        }
    }

    public DefaultContext(Connection connection) throws SQLException {
        super(m_profiles, connection);
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext constructor exit : " + this + " for connection :" + connection);
        }
    }

    public DefaultContext(String string, String string2, String string3, boolean bl2) throws SQLException {
        super(m_profiles, string, string2, string3, bl2);
    }

    public DefaultContext(String string, Properties properties, boolean bl2) throws SQLException {
        super(m_profiles, string, properties, bl2);
    }

    public DefaultContext(String string, boolean bl2) throws SQLException {
        super(m_profiles, string, bl2);
    }

    public DefaultContext(ConnectionContext connectionContext) throws SQLException {
        super(m_profiles, connectionContext);
    }

    public Map getTypeMap() {
        return null;
    }
}

