/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.am.ErrorKey;
import com.ibm.db2.jcc.am.bb;
import com.ibm.db2.jcc.am.ed;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public abstract class DB2FileReference {
    public static final int DB2_SQL_FILE_READ = 2;
    public static final int DB2_SQL_FILE_CREATE = 8;
    public static final int DB2_SQL_FILE_OVERWRITE = 16;
    public static final int DB2_SQL_FILE_APPEND = 32;
    public static final short MAX_FILE_NAME_LENGTH = 255;
    String fileName_;
    int dataLength_ = 0;
    int fileOptions_ = 2;
    String fileEncoding_;
    int fileCcsid_;
    int driverType_;

    protected DB2FileReference(String string, int n2, int n3) throws SQLException {
        this.init(string, n3);
        this.fileCcsid_ = n2;
        if (n3 == -100003 || n3 == -100005) {
            try {
                this.fileEncoding_ = bb.a(n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ed.a((Object)this, null, ErrorKey.UNSUPPORTED_CCSID_ENCODING, (Object)("" + this.fileCcsid_), "12926");
            }
        }
    }

    protected DB2FileReference(String string, String string2, int n2) throws SQLException {
        this.init(string, n2);
        this.fileEncoding_ = string2;
        if (n2 == -100003 || n2 == -100005) {
            if (string2 == null) {
                throw ed.a((Object)this, null, ErrorKey.UNSUPPORTED_CCSID_ENCODING, (Object)string2, "12954");
            }
            try {
                this.fileCcsid_ = bb.b(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ed.a((Object)this, null, ErrorKey.UNSUPPORTED_CCSID_ENCODING, (Object)string2, "12927");
            }
        }
    }

    private void init(String string, int n2) throws SQLException {
        this.checkFileName(string);
        this.fileName_ = string;
        this.checkDriverType(n2);
        this.driverType_ = n2;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String string) throws SQLException {
        this.checkFileName(string);
        this.fileName_ = string;
    }

    public int getDataLength() {
        return this.dataLength_;
    }

    public void setDataLength(int n2) {
        this.dataLength_ = n2;
    }

    public int getFileOptions() {
        return this.fileOptions_;
    }

    public void setFileOptions(int n2) throws SQLException {
    }

    public String getFileEncoding() {
        return this.fileEncoding_;
    }

    public int getFileCcsid() {
        return this.fileCcsid_;
    }

    public int getDriverType() {
        return this.driverType_;
    }

    private void checkFileName(String string) throws SQLException {
        int n2;
        if (string == null || (n2 = string.length()) < 1) {
            throw ed.a((Object)this, null, ErrorKey.INVALID_FILE_REF_EMPTY_NULL_VALUE, "12928");
        }
        if (n2 > 255) {
            throw ed.a((Object)this, null, ErrorKey.INVALID_LENGTH, (Object)new Integer(n2), "12929");
        }
    }

    private void checkFileOptions(int n2) throws SQLException {
        if (n2 != 2 && n2 != 8 && n2 != 32 && n2 != 16) {
            throw ed.a((Object)this, null, ErrorKey.INVALID_FILE_OPTIONS, (Object)new Integer(n2), "12930");
        }
    }

    private void checkDriverType(int n2) throws SQLException {
        if (n2 != -100002 && n2 != -100003 && n2 != -100004 && n2 != -100005) {
            throw ed.a((Object)this, null, ErrorKey.INVALID_JDBC_TYPE, (Object)new Integer(n2), "12931");
        }
    }
}

