/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.ListCache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache/list"})
public class CacheListController {
    private static final Logger log = LoggerFactory.getLogger(CacheListController.class);
    @CacheBean(layer={"caffeine"})
    private ListCache<String, CacheTestModel> cacheListCaffeine;
    @CacheBean
    private ListCache<String, CacheTestModel> cacheListRedis;

    @GetMapping(value={"/caffeine/put/{key}"})
    public Flux<CacheTestModel> putCaffeineList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putList(this.cacheListCaffeine, key, id, name, index, duration);
    }

    private Flux<CacheTestModel> putList(ListCache<String, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index, Long duration) {
        ArrayList<CacheTestModel> models = new ArrayList<CacheTestModel>();
        return ModelUtil.putCollection(cache, models, key, id, name, index, duration);
    }

    @GetMapping(value={"/caffeine/get/{key}"})
    public Flux<CacheTestModel> getCaffeineList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListCaffeine.get((Object)key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping(value={"/caffeine/del/{key}"})
    public Mono<Long> delCaffeineList(@PathVariable(value="key") String key) {
        return this.cacheListCaffeine.delete((Object)key);
    }

    @GetMapping(value={"/caffeine/rpush/{key}"})
    public Mono<Boolean> rpushCaffeineList(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return this.cacheListCaffeine.rpush((Object)key, (Object)model);
    }

    @GetMapping(value={"/caffeine/lpush/{key}"})
    public Mono<Boolean> lpushCaffeineList(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return this.cacheListCaffeine.lpush((Object)key, (Object)model);
    }

    @GetMapping(value={"/caffeine/rpop/{key}"})
    public Mono<CacheTestModel> rpopCaffeineList(@PathVariable(value="key") String key) {
        return this.cacheListCaffeine.rpop((Object)key);
    }

    @GetMapping(value={"/caffeine/lpop/{key}"})
    public Mono<CacheTestModel> lpopCaffeineList(@PathVariable(value="key") String key) {
        return this.cacheListCaffeine.lpop((Object)key);
    }

    @GetMapping(value={"/redis/put/{key}"})
    public Flux<CacheTestModel> putRedisList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putList(this.cacheListRedis, key, id, name, index, duration);
    }

    @GetMapping(value={"/redis/get/{key}"})
    public Flux<CacheTestModel> getRedisList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListRedis.get((Object)key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping(value={"/redis/del/{key}"})
    public Mono<Long> delRedisList(@PathVariable(value="key") String key) {
        return this.cacheListRedis.delete((Object)key);
    }

    @GetMapping(value={"/redis/rpush/{key}"})
    public Mono<Boolean> rpushRedisList(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return this.cacheListRedis.rpush((Object)key, (Object)model);
    }

    @GetMapping(value={"/redis/lpush/{key}"})
    public Mono<Boolean> lpushRedisList(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return this.cacheListRedis.lpush((Object)key, (Object)model);
    }

    @GetMapping(value={"/redis/rpop/{key}"})
    public Mono<CacheTestModel> rpopRedisList(@PathVariable(value="key") String key) {
        return this.cacheListRedis.rpop((Object)key);
    }

    @GetMapping(value={"/redis/lpop/{key}"})
    public Mono<CacheTestModel> lpopRedisList(@PathVariable(value="key") String key) {
        return this.cacheListRedis.lpop((Object)key);
    }
}

