/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.HashCache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache/map"})
public class CacheHashController {
    private static final Logger log = LoggerFactory.getLogger(CacheHashController.class);
    @CacheBean(layer={"caffeine"})
    private HashCache<String, Long, CacheTestModel> cacheMapCaffeine;
    @CacheBean
    private HashCache<String, Long, CacheTestModel> cacheMapRedis;

    private Mono<Boolean> addMap(HashCache<String, Long, CacheTestModel> cache, String key, long id, String name, Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return cache.add((Object)key, (Object)id, (Object)model);
    }

    private Flux<CacheTestModel> putMap(HashCache<String, Long, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index, Long duration) {
        HashMap<Long, CacheTestModel> models = new HashMap<Long, CacheTestModel>(id.length);
        for (int i = 0; i < id.length; ++i) {
            CacheTestModel model = ModelUtil.buildModel(i, id, name, index);
            models.put(model.getId(), model);
        }
        return cache.put((Object)key, models, duration, TimeUnit.SECONDS).flatMapIterable(r -> models.values());
    }

    @GetMapping(value={"/caffeine/put/{key}"})
    public Flux<CacheTestModel> putCaffeineHash(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putMap(this.cacheMapCaffeine, key, id, name, index, duration);
    }

    @GetMapping(value={"/caffeine/get/{key}"})
    public Flux<CacheTestModel> getCaffeineHash(@PathVariable(value="key") String key) {
        return this.cacheMapCaffeine.get((Object)key).flatMapIterable(Map::values);
    }

    @GetMapping(value={"/caffeine/add/{key}"})
    public Mono<Boolean> addCaffeineHash(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.addMap(this.cacheMapCaffeine, key, id, name, index);
    }

    @GetMapping(value={"/caffeine/key/{key}/{id}"})
    public CacheTestModel getCaffeineHashList(@PathVariable(value="key") String key, @PathVariable(value="id") long id) {
        Mono mono = this.cacheMapCaffeine.get((Object)key, (Object)id);
        return (CacheTestModel)mono.block();
    }

    @GetMapping(value={"/caffeine/del/{key}"})
    public Mono<Long> delCaffeineHash(@PathVariable(value="key") String key) {
        return this.cacheMapCaffeine.delete((Object)key);
    }

    @GetMapping(value={"/caffeine/del/{key}/{id}"})
    public Mono<Long> delCaffeineHashKey(@PathVariable(value="key") String key, @PathVariable(value="id") Long id) {
        return this.cacheMapCaffeine.remove((Object)key, (Object)id);
    }

    @GetMapping(value={"/caffeine/has/{key}/{id}"})
    public Mono<Boolean> hasCaffeineHash(@PathVariable(value="key") String key, @PathVariable(value="id") Long id) {
        return this.cacheMapCaffeine.exist((Object)key, (Object)id);
    }

    @GetMapping(value={"/redis/put/{key}"})
    public Flux<CacheTestModel> putRedisHash(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putMap(this.cacheMapRedis, key, id, name, index, duration);
    }

    @GetMapping(value={"/redis/get/{key}"})
    public Flux<CacheTestModel> getRedisHash(@PathVariable(value="key") String key) {
        return this.cacheMapRedis.get((Object)key).flatMapIterable(Map::values);
    }

    @GetMapping(value={"/redis/add/{key}"})
    public Mono<Boolean> addRedisHash(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.addMap(this.cacheMapRedis, key, id, name, index);
    }

    @GetMapping(value={"/redis/key/{key}/{id}"})
    public CacheTestModel getRedisHashList(@PathVariable(value="key") String key, @PathVariable(value="id") long id) {
        Mono mono = this.cacheMapRedis.get((Object)key, (Object)id);
        return (CacheTestModel)mono.block();
    }

    @GetMapping(value={"/redis/del/{key}/{id}"})
    public Mono<Long> delRedisHashKey(@PathVariable(value="key") String key, @PathVariable(value="id") Long id) {
        return this.cacheMapRedis.remove((Object)key, (Object)id);
    }

    @GetMapping(value={"/redis/del/{key}"})
    public Mono<Long> delRedisHash(@PathVariable(value="key") String key) {
        return this.cacheMapRedis.delete((Object)key);
    }

    @GetMapping(value={"/redis/has/{key}/{id}"})
    public Mono<Boolean> hasRedisHash(@PathVariable(value="key") String key, @PathVariable(value="id") Long id) {
        return this.cacheMapRedis.exist((Object)key, (Object)id);
    }
}

